/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.smfile.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.MovieSmFileRequest;
import com.xforceplus.vanke.in.repository.dao.SmFileInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceExample;
import com.xforceplus.vanke.in.service.smfile.SmFileInvoiceBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MovieSmFileProcess
extends AbstractProcess<MovieSmFileRequest, Boolean> {
    @Autowired
    private SmFileInvoiceDao smFileInvoiceDao;
    @Autowired
    private SmFileInvoiceBusiness smFileInvoiceBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(MovieSmFileRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getParentId(), "\u7236id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(MovieSmFileRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (!this.smFileInvoiceBusiness.tryLockByUserId(Long.valueOf(userSessionInfo.getAccountId()))) {
            return CommonResponse.failed((String)"\u4e1a\u52a1\u7e41\u5fd9\u8bf7\u91cd\u8bd5");
        }
        try {
            SmFileInvoiceExample example = new SmFileInvoiceExample();
            example.createCriteria().andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId())).andIdIn(request.getKeys());
            long count = this.smFileInvoiceDao.countByExample(example);
            if (count != (long)request.getKeys().size()) {
                CommonResponse commonResponse = CommonResponse.failed((String)"\u90e8\u5206\u79fb\u52a8\u6570\u636e\u4e0d\u5b58\u5728");
                return commonResponse;
            }
            example.clear();
            example.createCriteria().andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId()));
            example.setOrderByClause("fileOrder");
            List entities = this.smFileInvoiceDao.selectByExample(example);
            this.smFileInvoiceBusiness.movie(entities, request.getParentId(), request.getKeys());
            CommonResponse commonResponse = CommonResponse.ok((String)"\u5220\u9664\u6210\u529f", (Object)true);
            return commonResponse;
        }
        finally {
            this.smFileInvoiceBusiness.releaseLockByUserId(Long.valueOf(userSessionInfo.getAccountId()));
        }
    }
}

