/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.workbench.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.WorkBenchBean;
import com.xforceplus.vanke.in.repository.daoext.InvoiceDaoExt;
import com.xforceplus.vanke.in.repository.daoext.ReportDaoExt;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.InvoiceFilterBusiness;
import com.xforceplus.vanke.sc.service.MenuBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPengdingWorkProcess
extends AbstractProcess<BaseRequest, List<WorkBenchBean>> {
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private InvoiceDaoExt invoiceDaoExt;
    @Autowired
    private InvoiceFilterBusiness invoiceFilterBusiness;
    @Autowired
    private ReportDaoExt reportDaoExt;
    @Autowired
    private MenuBusiness menuBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    private final String ABNORMAL_MONITORING_ICON = "icondaisaomiaofapiao";
    private final String PENGDING_PROCESS_POSTCODE_ICON = "icondaichuli";
    private final String PENGDING_SCAN_INVOICE_ICON = "icondaisaomiaofapiao";
    private final String PENDING_PROCESS_EXCEPTION_ICON = "icondaichuliyichang";
    private final String PENDING_ELECTRONIC_ACCOUNT_ICON = "icondizhangdairenzheng";
    private final String PENDING_WEB_AUTHENTICATION_ICON = "iconchuantongdairenzheng";
    private final String PENDING_NO_AUTHENTICATION_ICON = "iconweikaitongtongdao";
    private final String ELECTRONIC_ACCOUNT_WARNING_ICON = "icondizhangrenzhengkuaidaoqi";
    private final String INTERFACE_EXCEPTION_ICON = "icondaichuliyichang";
    private final String INTERFACE_EXCEPTION_DESC = "\u63a5\u53e3\u63a8\u9001\u5f02\u5e38\u6570\u636e";
    private final String ABNORMAL_MONITORING_DES = "\u7edf\u8ba1\u6240\u6709\u8d85\u671f\u7684\u4e1a\u52a1\u5355\u6570\u636e";
    private final String PENGDING_PROCESS_POSTCODE_DES = "\u5df2\u7b7e\u6536\u4f46\u672a\u62c6\u5305\u7684\u6240\u6709\u90ae\u5305";
    private final String PENGDING_SCAN_INVOICE_DES = "\u5df2\u7b7e\u6536\u4f46\u672a\u626b\u63cf\u6216\u4e0a\u4f20\u5f71\u50cf\u7684\u6240\u6709\u53d1\u7968";
    private final String PENDING_PROCESS_EXCEPTION_DES = "\u7531\u7b7e\u6536\u5c97\u3001\u5ba1\u6838\u5c97\u3001\u8ba4\u8bc1\u5c97\u8f6c\u5165\u7684\u6240\u6709\u5f02\u5e38\u7968\u636e";
    private final String PENDING_ELECTRONIC_ACCOUNT_DES = "\u53ef\u5e95\u8d26\u52fe\u9009\uff0c\u4f46\u672a\u52fe\u9009\u7684\u6240\u6709\u53d1\u7968";
    private final String PENDING_WEB_AUTHENTICATION_DES = "\u53ef\u626b\u63cf\u52fe\u9009\uff0c\u4f46\u672a\u52fe\u9009\u7684\u6240\u6709\u53d1\u7968";
    private final String PENDING_NO_AUTHENTICATION_DES = "\u672a\u5f00\u901a\u5e95\u8d26\u3001\u4f20\u7edf\u62b5\u6263\u901a\u9053\uff0c\u6682\u65e0\u6cd5\u62b5\u6263\u7684\u6240\u6709\u53d1\u7968";
    private final String ELECTRONIC_ACCOUNT_WARNING_DES = "\u5373\u5c06\u903e\u671f\u7684\u6240\u6709\u53ef\u62b5\u6263\u53d1\u7968";

    protected CommonResponse<List<WorkBenchBean>> process(BaseRequest request) throws RuntimeException {
        long start = System.currentTimeMillis();
        ArrayList list = Lists.newArrayList();
        UserSessionInfo userInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        List sysMenuEntities = this.menuBusiness.getSysMenuList(userInfo);
        ArrayList futures = new ArrayList();
        sysMenuEntities.stream().forEach(sysMenuEntity -> {
            switch (sysMenuEntity.getMenuPath()) {
                case "/postcode": {
                    this.getData(list, "icondaichuli", "\u5f85\u5904\u7406\u5305\u88f9", "\u5df2\u7b7e\u6536\u4f46\u672a\u62c6\u5305\u7684\u6240\u6709\u90ae\u5305", 0, "pengdingPostCode");
                    break;
                }
                case "/scan": {
                    this.getData(list, "icondaisaomiaofapiao", "\u5f85\u626b\u63cf\u53d1\u7968", "\u5df2\u7b7e\u6536\u4f46\u672a\u626b\u63cf\u6216\u4e0a\u4f20\u5f71\u50cf\u7684\u6240\u6709\u53d1\u7968", 1, "pengdingScan");
                    break;
                }
                case "/abnormal": {
                    this.getData(list, "icondaichuliyichang", "\u5f85\u5904\u7406\u5f02\u5e38", "\u7531\u7b7e\u6536\u5c97\u3001\u5ba1\u6838\u5c97\u3001\u8ba4\u8bc1\u5c97\u8f6c\u5165\u7684\u6240\u6709\u5f02\u5e38\u7968\u636e", 2, "pengdingException");
                    break;
                }
                case "/invoiceAuth": {
                    this.getData(list, "icondizhangdairenzheng", "\u5e95\u8d26\u5f85\u52fe\u9009", "\u53ef\u5e95\u8d26\u52fe\u9009\uff0c\u4f46\u672a\u52fe\u9009\u7684\u6240\u6709\u53d1\u7968", 3, "pengdingAccount");
                    this.getData(list, "iconchuantongdairenzheng", "\u626b\u63cf\u5f85\u52fe\u9009", "\u53ef\u626b\u63cf\u52fe\u9009\uff0c\u4f46\u672a\u52fe\u9009\u7684\u6240\u6709\u53d1\u7968", 4, "pengdingWebAuth");
                    this.getData(list, "iconweikaitongtongdao", "\u672a\u5f00\u901a\u62b5\u6263\u901a\u9053", "\u672a\u5f00\u901a\u5e95\u8d26\u3001\u4f20\u7edf\u62b5\u6263\u901a\u9053\uff0c\u6682\u65e0\u6cd5\u62b5\u6263\u7684\u6240\u6709\u53d1\u7968", 5, "pengdingNoAuth");
                    this.getData(list, "icondizhangrenzhengkuaidaoqi", "\u62b5\u6263\u5feb\u5230\u671f", "\u5373\u5c06\u903e\u671f\u7684\u6240\u6709\u53ef\u62b5\u6263\u53d1\u7968", 6, "electronicAccountWarning");
                    break;
                }
                case "/abnormalMonitoring": {
                    this.getData(list, "icondaisaomiaofapiao", "\u5361\u5355\u9884\u8b66", "\u7edf\u8ba1\u6240\u6709\u8d85\u671f\u7684\u4e1a\u52a1\u5355\u6570\u636e", 7, "pengdingAbnormalMonitoring");
                    break;
                }
                case "/interfaceAbnormalMonitoring": {
                    this.getData(list, "icondaichuliyichang", "\u63a5\u53e3\u9884\u8b66", "\u63a5\u53e3\u63a8\u9001\u5f02\u5e38\u6570\u636e", 8, "interfaceException");
                    break;
                }
            }
        });
        list.sort(Comparator.comparing(WorkBenchBean::getOrderNo));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)list);
    }

    protected void getData(List<WorkBenchBean> list, String icon, String title, String content, int orderNo, String name) {
        WorkBenchBean workBenchBean = new WorkBenchBean();
        workBenchBean.setIcon(icon);
        workBenchBean.setTitle(title);
        workBenchBean.setContent(content);
        workBenchBean.setOrderNo(orderNo);
        workBenchBean.setName(name);
        list.add(workBenchBean);
    }
}

