/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.api.imsCore.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.vanke.sc.outer.api.imsApi.serving.cloud.ims.api.constant.ErrorEnum;
import com.xforceplus.vanke.sc.outer.api.imsApi.serving.cloud.ims.api.exception.ServiceException;
import com.xforceplus.vanke.sc.outer.api.imsCore.aop.LoggableParam;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.system.User;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.ip.IpSeeker;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.ip.IpUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);
    public static final String LOGIN_USER = "loginUser";

    private Util() {
    }

    public static <T> T readValue(String jsonString, Class<T> className) throws ServiceException {
        Object t = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            t = objectMapper.readValue(jsonString, className);
        }
        catch (Exception e) {
            LOGGER.error("\u9700\u8981\u8f6c\u6362\u7684\u5b57\u7b26\u4e32\uff1a{}\uff0c\u9700\u8981\u8f6c\u5316\u6210\u7684\u5bf9\u8c61\uff1a{}", new Object[]{jsonString, className.toString()});
            throw new ServiceException(ErrorEnum.JSON_READ_ERROR);
        }
        return (T)t;
    }

    public static String writeValueAsString(Object t) throws ServiceException {
        String jsonString = "";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
            simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            objectMapper.registerModule((Module)simpleModule);
            objectMapper.configure(SerializationFeature.INDENT_OUTPUT, Boolean.TRUE.booleanValue());
            jsonString = objectMapper.writeValueAsString(t);
        }
        catch (Exception e) {
            LOGGER.error("\u9700\u8981\u8f6c\u6362\u7684\u5bf9\u8c61\uff1a{}", new Object[]{t.toString()});
            throw new ServiceException(ErrorEnum.JSON_WRITE_ERROR);
        }
        return jsonString;
    }

    public static void addCookie(HttpServletResponse response, HttpServletRequest request, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        String contextPath = request.getContextPath();
        String path = contextPath.length() > 0 ? contextPath : "/";
        cookie.setPath(path);
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        cookie.setSecure(request.isSecure());
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public static String getCookie(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void deleteCookie(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                cookie.setMaxAge(0);
            }
        }
    }

    public static String getWebInfoRealPath() {
        URL url = Util.class.getResource("");
        String path = url.toString();
        int index = path.indexOf("WEB-INF");
        if (index == -1) {
            index = path.indexOf("classes");
        }
        if (index == -1) {
            index = path.indexOf("bin");
        }
        if ((path = path.substring(0, index)).startsWith("zip")) {
            path = path.substring(4);
        } else if (path.startsWith("file")) {
            path = path.substring(6);
        } else if (path.startsWith("jar")) {
            path = path.substring(10);
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u83b7\u53d6\u9879\u76ee\u7edd\u5bf9\u8def\u5f84", (Throwable)e);
            path = "/";
        }
        String separator = File.separator;
        if ("/".equals(separator)) {
            path = "/" + path;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void responseWrite(HttpServletResponse response, Object object) {
        PrintWriter out = null;
        try {
            response.setContentType("text/html;charset=utf-8");
            out = response.getWriter();
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
            simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            objectMapper.registerModule((Module)simpleModule);
            objectMapper.configure(SerializationFeature.INDENT_OUTPUT, Boolean.TRUE.booleanValue());
            String json = objectMapper.writeValueAsString(object);
            out.write(json);
            out.flush();
        }
        catch (IOException e) {
            LOGGER.error("\u5f80\u5ba2\u6237\u7aef\u56de\u5199JSON\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u5bf9\u8c61\uff1a{}", (Object)object.toString(), (Object)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    public static Method getMethod(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        return method;
    }

    public static void setSessionValue(HttpServletRequest request, String key, Object value) {
        request.getSession().setAttribute(key, value);
    }

    public static <T> T getSessionValue(HttpServletRequest request, String key) {
        Object t = null;
        Object object = request.getSession().getAttribute(key);
        if (null == object) {
            return (T)t;
        }
        t = object;
        return (T)t;
    }

    public static String formatValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return value;
    }

    public static int getLength(String s) {
        int length = 0;
        for (int i = 0; i < s.length(); ++i) {
            int ascii = Character.codePointAt(s, i);
            if (ascii >= 0 && ascii <= 255) {
                ++length;
                continue;
            }
            length += 2;
        }
        return length;
    }

    public static long getLoginUser() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return Util.getLoggableParam(request, true).getUserId();
    }

    public static long getLoginUser(HttpServletRequest request) {
        User user = (User)Util.getSessionValue(request, LOGIN_USER);
        return user.getId().intValue();
    }

    public static User getLoginUserInfo(HttpServletRequest request) {
        User user = (User)Util.getSessionValue(request, LOGIN_USER);
        return user;
    }

    public static LoggableParam getLoggableParam(HttpServletRequest request, boolean use) {
        Integer i;
        String ip = IpUtil.getRequestIP(request);
        IpSeeker ipSeeker = IpSeeker.getInstance();
        String address = ipSeeker.getAddress(ip);
        User user = (User)Util.getSessionValue(request, LOGIN_USER);
        Long userId = null;
        if (null != user && (i = user.getId()) != null) {
            userId = i.longValue();
        }
        LoggableParam loggableParam = new LoggableParam(ip, address, userId);
        loggableParam.setUse(use);
        return loggableParam;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String headerRequest = request.getHeader("x-requested-with");
        return headerRequest != null && headerRequest.equalsIgnoreCase("XMLHttpRequest");
    }

    public static JSONArray JSONArrayToTree(JSONArray menuList, String parentId) {
        JSONArray childMenu = new JSONArray();
        for (Object object : menuList) {
            JSONObject jsonMenu = JSONObject.fromObject(object);
            String menuId = jsonMenu.getString("id");
            String pid = jsonMenu.getString("pId");
            if (!parentId.equals(pid)) continue;
            JSONArray c_node = Util.JSONArrayToTree(menuList, menuId);
            if (c_node.size() != 0) {
                jsonMenu.put((Object)"nodes", (Object)c_node);
            }
            childMenu.add((Object)jsonMenu);
        }
        return childMenu;
    }

    public static List<?> splitList(List<?> oldList, int size) {
        ArrayList newList = new ArrayList();
        ArrayList returnList = new ArrayList();
        ArrayList lastList = new ArrayList();
        int allCount = oldList.size();
        int count = allCount / size;
        int residue = allCount % size;
        System.out.println("allCount " + allCount + " -- size " + size + " -- count " + count + " -- residue " + residue);
        for (int i = 0; i < allCount; ++i) {
            ArrayList tempList;
            if (0 != i && 0 == i % size) {
                tempList = new ArrayList();
                tempList.addAll(newList);
                returnList.add(tempList);
                newList.removeAll(newList);
            }
            if (0 == i % size || 0 != i % size) {
                newList.add(oldList.get(i));
            }
            if (i >= size * count) {
                lastList.add(oldList.get(i));
            }
            if (i != allCount - 1) continue;
            tempList = new ArrayList();
            tempList.addAll(lastList);
            returnList.add(tempList);
            lastList.removeAll(lastList);
        }
        return returnList;
    }

    public static User getSessionUser() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        User user = (User)Util.getSessionValue(request, LOGIN_USER);
        return user;
    }

    public static boolean eqBigDecimal(BigDecimal a, BigDecimal b) {
        if (a != null && b != null) {
            return a.compareTo(b) == 0;
        }
        return a == null && b == null;
    }
}

