/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.pdc;

import com.xforceplus.vanke.sc.outer.api.imsApi.serving.cloud.ims.api.util.ApiMonitorUtil;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefpservice.InvoiceFPService;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefpservice.InvoiceRQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefpservice.InvoiceRS;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.pdc.settlementresultservice.SettlementResultRQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.pdc.settlementresultservice.SettlementResultRS;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.pdc.settlementresultservice.SettlementResultService;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.DateUtil;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.PropertieUtil;
import net.sf.json.JSONObject;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PDCInterfaceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDCInterfaceImpl.class);
    private static final String INVOICE_ADDRESS = PropertieUtil.invoiceFPUrl;
    private static final String SETTLEMENT_ADDRESS = PropertieUtil.settlementResultUrl;

    public JSONObject authResultSync(InvoiceRQ invoiceRQ) {
        JSONObject result = null;
        try {
            JaxWsProxyFactoryBean bean = new JaxWsProxyFactoryBean();
            bean.setAddress(INVOICE_ADDRESS);
            bean.setServiceClass(InvoiceFPService.class);
            InvoiceFPService service = (InvoiceFPService)bean.create();
            LOGGER.info("PDC_AUTH_RESULT - \u670d\u52a1\u5668 - " + DateUtil.getCurrentTime() + " - " + "1" + " - PDC_INTERFACE");
            InvoiceRS rs = service.invoiceFP(invoiceRQ);
            JSONObject json = JSONObject.fromObject((Object)rs.getRtnInfo().get(0).getTextMessage());
            LOGGER.info("\u53d1\u7968\u4fe1\u606f\uff0c\u5ba1\u6838\u4fe1\u606f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u63a8\u9001\u81f3PDC\u7ed3\u679c: " + json.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u53d1\u7968\u4fe1\u606f\uff0c\u5ba1\u6838\u4fe1\u606f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u63a8\u9001\u81f3PDC\u63a5\u53e3 - \u8bf7\u6c42\u5f02\u5e38\u54cd\u5e94: [{}]", (Object)e.getMessage());
        }
        return result;
    }

    public void settlementResult(SettlementResultRQ rq) {
        try {
            JaxWsProxyFactoryBean bean = new JaxWsProxyFactoryBean();
            bean.setAddress(SETTLEMENT_ADDRESS);
            bean.setServiceClass(SettlementResultService.class);
            SettlementResultService service = (SettlementResultService)bean.create();
            SettlementResultRS rs = service.settlementResult(rq);
            String jsonStr = ApiMonitorUtil.toJSONString(rs);
            LOGGER.info("\u7ed3\u7b97\u5355\u53cd\u9988\u63a5\u53e3OSB -------------- " + jsonStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("PDC\u534f\u540c\u7ed3\u7b97\u5355\u53cd\u9988\u63a5\u53e3 - \u8bf7\u6c42\u5f02\u5e38\u54cd\u5e94: [{}]", (Object)e.getMessage());
        }
    }
}

