/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.sap;

import com.xforceplus.vanke.sc.outer.api.imsApi.serving.cloud.ims.api.util.ApiMonitorUtil;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.SRMREQUEST;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.SRMRESPONSE;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.SRMService;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.v1.RETURNSTATUS;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.base.DT_BASEINFO;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_INVOICESTATUS_REQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_INVOICESTATUS_RSP;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_INVOICESTATUS_RSPE_RESPONSERETURNSTATUS;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_LEGALPERSONSTATUS_REQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.SI_PO_INVOICESTATUS_OUT_SYNBindingStub;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.SI_PO_INVOICESTATUS_OUT_SYNServiceLocator;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.SI_PO_LEGALPERSONSTATUS_OUT_ASYBindingStub;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.SI_PO_LEGALPERSONSTATUS_OUT_ASYServiceLocator;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.DT_PO_SETTLEMENTXYJSTA_REQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.DT_PO_SETTLEMENTXYJSTA_RSP;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.SI_PO_SETTLEMENTXYJSTA_OUT_SYNBindingStub;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.SI_PO_SETTLEMENTXYJSTA_OUT_SYNServiceLocator;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.DateUtil;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.PropertieUtil;
import java.rmi.RemoteException;
import java.util.UUID;
import javax.xml.rpc.ServiceException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SAPInterfaceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAPInterfaceImpl.class);
    private static final String S_SYSTEM = PropertieUtil.sapS_System;
    private static final String T_SYSTEM = PropertieUtil.sapT_System;
    private static final String COMPANY_INFO_ADDRESS = PropertieUtil.sapOsbCompanyInfoUrl;

    public String settlementResult(DT_PO_SETTLEMENTXYJSTA_REQ request) {
        String jsonStr = "";
        String originSystem = "SAP";
        try {
            if (null == request) {
                return jsonStr;
            }
            SI_PO_SETTLEMENTXYJSTA_OUT_SYNServiceLocator locator = new SI_PO_SETTLEMENTXYJSTA_OUT_SYNServiceLocator();
            SI_PO_SETTLEMENTXYJSTA_OUT_SYNBindingStub stub = (SI_PO_SETTLEMENTXYJSTA_OUT_SYNBindingStub)locator.getHTTP_Port();
            stub.setUsername(PropertieUtil.sapUserName);
            stub.setPassword(PropertieUtil.sapPassword);
            LOGGER.info("\u8c03\u7528\u4e07\u79d1\u3010\u534f\u540c\u7ed3\u7b97\u5355\u53cd\u9988\u3011\u63a5\u53e3\u8bf7\u6c42\uff1a{}", (Object)JSONObject.fromObject((Object)request).toString());
            DT_PO_SETTLEMENTXYJSTA_RSP response = stub.SI_PO_SETTLEMENTXYJSTA_OUT_SYN(request);
            jsonStr = ApiMonitorUtil.toJSONString(response.getE_RESPONSE().getRETURNSTATUS());
            LOGGER.info("\u8c03\u7528\u4e07\u79d1\u3010\u534f\u540c\u7ed3\u7b97\u5355\u53cd\u9988\u3011\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)jsonStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(originSystem + "\u534f\u540c\u7ed3\u7b97\u5355\u53cd\u9988\u63a5\u53e3 - \u8bf7\u6c42\u5f02\u5e38\u54cd\u5e94: [{}]", (Object)e.getMessage());
        }
        return jsonStr;
    }

    private JSONArray invoiceStatusResults(DT_PO_INVOICESTATUS_REQ rq) {
        JSONArray jsonArray = null;
        try {
            SI_PO_INVOICESTATUS_OUT_SYNServiceLocator service = new SI_PO_INVOICESTATUS_OUT_SYNServiceLocator();
            SI_PO_INVOICESTATUS_OUT_SYNBindingStub so = (SI_PO_INVOICESTATUS_OUT_SYNBindingStub)service.getHTTP_Port();
            so.setUsername(PropertieUtil.sapUserName);
            so.setPassword(PropertieUtil.sapPassword);
            DT_PO_INVOICESTATUS_RSP rs = so.SI_PO_INVOICESTATUS_OUT_SYN(rq);
            DT_PO_INVOICESTATUS_RSPE_RESPONSERETURNSTATUS[] result = rs.getE_RESPONSE().getRETURNSTATUS();
            if (null != result && 0 < result.length) {
                jsonArray = JSONArray.fromObject((Object)result);
            }
            LOGGER.info("##################################### \u53d1\u7968\u4fe1\u606f\uff0c\u5ba1\u6838\u4fe1\u606f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u63a8\u9001SAP\u63a5\u53e3\u6210\u529f\u54cd\u5e94: {} #####################################", (Object)jsonArray.toString());
        }
        catch (ServiceException e) {
            LOGGER.error("##################################### \u53d1\u7968\u4fe1\u606f\uff0c\u5ba1\u6838\u4fe1\u606f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u63a8\u9001SAP\u63a5\u53e3\u5f02\u5e38\u54cd\u5e94: {} #####################################", (Object)e.getMessage());
            e.printStackTrace();
        }
        catch (RemoteException e) {
            LOGGER.error("##################################### \u53d1\u7968\u4fe1\u606f\uff0c\u5ba1\u6838\u4fe1\u606f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u63a8\u9001SAP\u63a5\u53e3\u5f02\u5e38\u54cd\u5e94: {} #####################################", (Object)e.getMessage());
            e.printStackTrace();
        }
        return jsonArray;
    }

    public static DT_BASEINFO getBaseInfo(String serviceName) {
        DT_BASEINFO baseInfo = new DT_BASEINFO();
        baseInfo.setMSGID(UUID.randomUUID().toString().replaceAll("-", ""));
        baseInfo.setS_SYSTEM(S_SYSTEM);
        baseInfo.setSENDTIME(DateUtil.getNowTimeShortString());
        baseInfo.setSERVICENAME(serviceName);
        baseInfo.setT_SYSTEM(T_SYSTEM);
        baseInfo.setRETRY("1");
        return baseInfo;
    }

    public void legalPersonReceiveResult(DT_PO_LEGALPERSONSTATUS_REQ rq) {
        try {
            SI_PO_LEGALPERSONSTATUS_OUT_ASYServiceLocator service = new SI_PO_LEGALPERSONSTATUS_OUT_ASYServiceLocator();
            SI_PO_LEGALPERSONSTATUS_OUT_ASYBindingStub so = (SI_PO_LEGALPERSONSTATUS_OUT_ASYBindingStub)service.getHTTP_Port();
            so.setUsername(PropertieUtil.sapUserName);
            so.setPassword(PropertieUtil.sapPassword);
            so.SI_PO_LEGALPERSONSTATUS_OUT_ASY(rq);
            LOGGER.info("------------------------------------ \u8c03\u7528\u6cd5\u4eba\u4e3b\u6570\u636e[\u559c\u76c8\u4f73]\u53cd\u9988\u56de\u4f20SAP - \u8bf7\u6c42\u6210\u529f ------------------------------------");
        }
        catch (Exception e) {
            LOGGER.error("##################################### \u8c03\u7528\u6cd5\u4eba\u4e3b\u6570\u636e[\u559c\u76c8\u4f73]\u53cd\u9988\u56de\u4f20SAP - \u8bf7\u6c42\u5f02\u5e38\u54cd\u5e94: {} #####################################", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public void companyInfoDataResult(SRMREQUEST request) {
        try {
            JaxWsProxyFactoryBean bean = new JaxWsProxyFactoryBean();
            bean.setAddress(COMPANY_INFO_ADDRESS);
            bean.setServiceClass(SRMService.class);
            SRMService srmService = (SRMService)bean.create();
            SRMRESPONSE response = srmService.srmOperation(request);
            RETURNSTATUS rs = response.getRETURNSTATUS();
            String jsonStr = ApiMonitorUtil.toJSONString(rs);
            LOGGER.info("SAP\u4f9b\u5e94\u5546\u4fe1\u606f[\u559c\u76c8\u4f73]\u53cd\u9988 - \u8bf7\u6c42\u6210\u529f: [{}]", (Object)jsonStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("SAP\u4f9b\u5e94\u5546\u4fe1\u606f[\u559c\u76c8\u4f73]\u53cd\u9988 - \u8bf7\u6c42\u5f02\u5e38\u54cd\u5e94: [{}]", (Object)e.getMessage());
        }
    }
}

