/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.api.imsCore.util;

import com.xforceplus.vanke.sc.outer.api.imsCore.util.CommonTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OpenApiUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "tclientSecret";
    private static final String TOKEN_URL = "tokenUrl";

    public String getLoginToken() {
        String token = "";
        try {
            String clientId = CLIENT_ID;
            String clientSecret = CLIENT_SECRET;
            String url = TOKEN_URL;
            this.logger.info("\u83b7\u53d6OpenApi\u767b\u5f55token\u4fe1\u606f\u8bf7\u6c42\uff1a" + url);
            HttpPost httpPost = new HttpPost(url);
            if (!CommonTools.isEmpty(clientId) && !CommonTools.isEmpty(clientSecret)) {
                httpPost.setEntity((HttpEntity)new StringEntity(clientId, "utf-8"));
                httpPost.setEntity((HttpEntity)new StringEntity(clientSecret, "utf-8"));
            }
            httpPost.setHeader("content-type", APPLICATION_JSON);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String tokens = EntityUtils.toString((HttpEntity)entity);
                this.logger.info("\u83b7\u53d6OpenApi\u767b\u5f55token\u4fe1\u606f\uff1a" + tokens);
                Map map = CommonTools.writeJsonToMap(tokens);
                token = map.get("result").toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6OpenApi\u767b\u5f55token\u5931\u8d25\uff1a" + e.getMessage());
        }
        return token;
    }

    public HttpResponse doGet(String url, Map<String, String> headers, Map<String, String> querys) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (url.startsWith("https://")) {
            this.sslClient((HttpClient)httpClient);
        }
        HttpGet request = new HttpGet(this.buildUrl(url, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    private void sslClient(HttpClient httpClient) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            SchemeRegistry registry = ccm.getSchemeRegistry();
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String buildUrl(String url, Map<String, String> querys) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(url);
        if (null != querys) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((String)query.getKey()) && !StringUtils.isBlank((String)query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtils.isBlank((String)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (StringUtils.isBlank((String)query.getValue())) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue(), "utf-8"));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostJson(String url, String json, Map<String, String> headerParam) {
        String result = null;
        InputStream instream = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            if (null != headerParam) {
                for (Map.Entry<String, String> entry : headerParam.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity se = new StringEntity(json, DEFAULT_CHARSET);
            se.setContentType(CONTENT_TYPE_TEXT_JSON);
            se.setContentEncoding((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
            httpPost.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = OpenApiUtils.getStreamAsString(instream, DEFAULT_CHARSET);
            }
        }
        catch (Exception e) {
            this.logger.error("API\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        String result = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(stream, charset));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            result = buffer.toString();
        }
        finally {
            if (null != stream) {
                stream.close();
            }
            if (null != in) {
                in.close();
            }
        }
        return result;
    }
}

