/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.pyt;

import com.xforceplus.vanke.sc.outer.api.imsCore.entity.baseinfo.Response;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.invoice.InvoiceGeneralProInfo;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.CommonTools;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.OpenApiUtils;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.PropertieUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class PYTInterfaceImpl {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String LOGISTICS_INFO_URL = PropertieUtil.logisticsInfoUrl;
    private static final String UPLOAD_FILE_URL = PropertieUtil.uploadFileUrl;
    private static final String INVOICE_GENERAL_PRO_URL = PropertieUtil.uploadFileUrl;
    private static final String BATCH_TASK_URL = PropertieUtil.uploadFileUrl;
    private static final String group = PropertieUtil.group;
    private static final String appId = PropertieUtil.appId;
    @Autowired
    private OpenApiUtils openApiUtils;

    public String getLogisticsInfo(String expressCode, String mailNo) {
        String result = "";
        try {
            if (CommonTools.isEmpty(expressCode)) {
                return CommonTools.getStr(Response.from(Response.Fail, "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a.", result));
            }
            if (CommonTools.isEmpty(mailNo)) {
                return CommonTools.getStr(Response.from(Response.Fail, "\u7269\u6d41\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a.", result));
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("expressCode", expressCode);
            paramMap.put("mailNo", mailNo);
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("appId", appId);
            String timestamp = SDF.format(new Date());
            headerParam.put("timestamp", timestamp);
            HttpResponse httpResponse = this.openApiUtils.doGet(LOGISTICS_INFO_URL, headerParam, paramMap);
            HttpEntity entity = httpResponse.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7269\u6d41\u8f68\u8ff9\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return CommonTools.getStr(Response.from(Response.Fail, "\u7269\u6d41\u8f68\u8ff9\u67e5\u8be2\u6210\u529f", result));
    }

    public String uploadFile(MultipartFile file) {
        String result = "";
        try {
            if (file.isEmpty()) {
                return CommonTools.getStr(Response.from(Response.Fail, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.", result));
            }
            String token = this.openApiUtils.getLoginToken();
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("Content-Type", "application/json");
            headerParam.put("x-access-token", token);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("group", group);
            paramMap.put("file", (String)file);
            result = this.openApiUtils.doPostJson(UPLOAD_FILE_URL, CommonTools.writeMapToJson(paramMap), headerParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u4e0a\u4f20\u8bc6\u522b\u5f71\u50cf\u5931\u8d25\uff1a" + e.getMessage());
        }
        return CommonTools.getStr(Response.from(Response.Fail, "\u4e0a\u4f20\u8bc6\u522b\u5f71\u50cf\u6210\u529f", result));
    }

    public String invoiceGeneralPro(InvoiceGeneralProInfo invoiceGeneralProInfo) {
        String result = "";
        try {
            if (null == invoiceGeneralProInfo) {
                return CommonTools.getStr(Response.from(Response.Fail, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.", result));
            }
            String token = this.openApiUtils.getLoginToken();
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("Content-Type", "multipart/form-data");
            headerParam.put("x-access-token", token);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

