/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.utils;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

@Component(value="queueSenderScConst")
public class QueueSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueSender.class);
    @Autowired
    private JmsTemplate jmsTemplate;

    public void send(String queueName, String message, Map<String, String> propertys) {
        this.sendNoLog(queueName, message, propertys);
    }

    public void sendNoLog(String queueName, final String message, final Map<String, String> propertys) {
        LOGGER.info("\u5411queue\u961f\u5217:[{}]\u5f00\u59cb\u53d1\u9001\u6d88\u606f[{}]......", new Object[]{queueName, message});
        try {
            this.jmsTemplate.send(queueName, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    TextMessage textMessage = session.createTextMessage(message);
                    if (null != propertys && !propertys.isEmpty()) {
                        for (Map.Entry entry : propertys.entrySet()) {
                            textMessage.setStringProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    return textMessage;
                }
            });
        }
        catch (JmsException jmsException) {
            // empty catch block
        }
        LOGGER.info("\u5411queue\u961f\u5217:[{}]\u53d1\u9001\u6d88\u606f[{}]\u5df2\u5b8c\u6210", new Object[]{queueName, message});
    }
}

