/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.api.imsApi.serving.cloud.ims.api.util;

import com.xforceplus.vanke.sc.outer.api.imsCore.util.PropertieUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQConnectionFactory;

public class TextMessageSendUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int send(String queueName, String messageContent, Map<String, String> property) {
        int res = 1;
        Connection connection = null;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(PropertieUtil.mqUsername, PropertieUtil.mqPasswod, PropertieUtil.mqUrl);
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(Boolean.TRUE.booleanValue(), 1);
            Queue destination = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(1);
            TextMessage message = session.createTextMessage(messageContent);
            if (property != null) {
                for (String key : property.keySet()) {
                    message.setStringProperty(key, property.get(key));
                }
            }
            producer.send((Message)message);
            session.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            res = 0;
        }
        finally {
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return res;
    }

    public static void main(String[] args) {
        HashMap<String, String> property = new HashMap<String, String>();
        property.put("requestType", "1");
        property.put("requestSerialNo", UUID.randomUUID().toString().substring(0, 30));
        property.put("groupFlag", "SC@vanke");
        property.put("systemOrig", "SCFP");
        JSONObject body = new JSONObject();
        JSONObject invoiceMain = new JSONObject();
        invoiceMain.put((Object)"purchaserTaxNo", (Object)"1");
        invoiceMain.put((Object)"invoiceCode", (Object)"2");
        invoiceMain.put((Object)"invoiceNo", (Object)"3");
        invoiceMain.put((Object)"sellerTaxNo", (Object)"4");
        invoiceMain.put((Object)"paperDrewDate", (Object)"5");
        invoiceMain.put((Object)"amountWithoutTax", (Object)"6");
        invoiceMain.put((Object)"taxAmount", (Object)"7.00");
        invoiceMain.put((Object)"taxRate", (Object)"8.00");
        invoiceMain.put((Object)"cipherText", (Object)"9");
        invoiceMain.put((Object)"invoiceType", (Object)"10");
        invoiceMain.put((Object)"machineCode", (Object)"11");
        invoiceMain.put((Object)"twoCodeFlag", (Object)"12");
        invoiceMain.put((Object)"cipherTextTwocode", (Object)"13");
        invoiceMain.put((Object)"scanTime", (Object)"14");
        invoiceMain.put((Object)"authApplyUserId", (Object)"15");
        invoiceMain.put((Object)"authApplyTime", (Object)"16");
        JSONArray invoiceDetails = new JSONArray();
        body.put((Object)"invoiceMain", (Object)invoiceMain);
        body.put((Object)"invoiceDetails", (Object)invoiceDetails);
        TextMessageSendUtil.send("ims.test", body.toString(), property);
        System.out.println(body.toString());
    }
}

