/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.pyt;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.baseinfo.Response;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.invoice.InvoiceGeneralProInfo;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.CommonTools;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.HttpUtils;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.OpenApiUtils;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.PropertieUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class PYTInterfaceImpl {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String hostUrl = PropertieUtil.host;
    private static final String LOGISTICS_INFO_URL = PropertieUtil.logisticsInfoUrl;
    private static final String UPLOAD_FILE_URL = PropertieUtil.uploadFileUrl;
    private static final String INVOICE_GENERAL_PRO_URL = PropertieUtil.invoiceGeneralProUrl;
    private static final String BATCH_TASK_URL = PropertieUtil.batchTaskUrl;
    private static final String group = PropertieUtil.group;
    private static final String appId = PropertieUtil.appId;

    public Response getLogisticsInfo(String expressCode, String parcelNo) {
        String result = "";
        try {
            if (CommonTools.isEmpty(expressCode)) {
                return Response.from(Response.Fail, "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a.", result);
            }
            if (CommonTools.isEmpty(parcelNo)) {
                return Response.from(Response.Fail, "\u7269\u6d41\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a.", result);
            }
            String token = OpenApiUtils.getLoginToken();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("expressCode", expressCode);
            paramMap.put("parcelNo", parcelNo);
            HashMap<String, String> headerParam = new HashMap<String, String>();
            String timestamp = SDF.format(new Date());
            headerParam.put("timestamp", timestamp);
            headerParam.put("x-app-token", token);
            HttpResponse httpResponse = HttpUtils.doGet(hostUrl, LOGISTICS_INFO_URL, headerParam, paramMap);
            HttpEntity entity = httpResponse.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
            JSONObject resultObject = JSONObject.parseObject((String)result);
            String respCode = resultObject.getString("respCode");
            if (!"0000".equals(respCode)) {
                this.logger.info("\u7269\u6d41\u8f68\u8ff9\u67e5\u8be2\u5931\u8d25\uff1a" + result);
                return Response.from(Response.Fail, result);
            }
            this.logger.info("\u7269\u6d41\u8f68\u8ff9\u67e5\u8be2\u6210\u529f\uff1a" + result);
            return Response.from(Response.OK, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7269\u6d41\u8f68\u8ff9\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            return Response.from(Response.Fail, e.getMessage());
        }
    }

    public String uploadFile(MultipartFile file) {
        String result = "";
        try {
            if (file.isEmpty()) {
                return CommonTools.getStr(Response.from(Response.Fail, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.", result));
            }
            String token = OpenApiUtils.getLoginToken();
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("Content-Type", "application/json");
            headerParam.put("x-access-token", token);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("group", group);
            paramMap.put("file", (String)file);
            result = HttpUtils.doPostJson(UPLOAD_FILE_URL, CommonTools.writeMapToJson(paramMap), headerParam);
            this.logger.info("\u4e0a\u4f20\u8bc6\u522b\u5f71\u50cf\u6210\u529f\uff1a" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u4e0a\u4f20\u8bc6\u522b\u5f71\u50cf\u5931\u8d25\uff1a" + e.getMessage());
        }
        return CommonTools.getStr(Response.from(Response.OK, "\u4e0a\u4f20\u8bc6\u522b\u5f71\u50cf\u6210\u529f", result));
    }

    public String invoiceGeneralPro(InvoiceGeneralProInfo invoiceGeneralProInfo) {
        String result = "";
        try {
            if (null == invoiceGeneralProInfo) {
                return CommonTools.getStr(Response.from(Response.Fail, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.", result));
            }
            String token = OpenApiUtils.getLoginToken();
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("Content-Type", "multipart/form-data");
            headerParam.put("x-access-token", token);
            String paramJson = CommonTools.writeObjectToJson(invoiceGeneralProInfo);
            result = HttpUtils.doPostJson(INVOICE_GENERAL_PRO_URL, paramJson, headerParam);
            this.logger.info("\u53d1\u8d77\u5f71\u50cf\u8bc6\u522b\uff08\u5355\u7968\u8bc6\u522b\uff09AI\u589e\u5f3a-\u4e0d\u9650\u5b9a\u53d1\u7968\u7c7b\u578b\u6210\u529f\uff1a" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u53d1\u8d77\u5f71\u50cf\u8bc6\u522b\uff08\u5355\u7968\u8bc6\u522b\uff09\u5931\u8d25\uff1a" + e.getMessage());
        }
        return CommonTools.getStr(Response.from(Response.OK, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.", result));
    }

    public String getBatchTaskId(String[] taskIds) {
        String result = "";
        try {
            if (null == taskIds || taskIds.length == 0) {
                return CommonTools.getStr(Response.from(Response.Fail, "\u53d1\u7968\u8bc6\u522b\u7ed3\u679c\u67e5\u8be2\uff08\u83b7\u53d6\u8bc6\u522b\u4efb\u52a1(\u6279\u91cf)\uff09\u67e5\u8be2\u6210\u529f", result));
            }
            String token = OpenApiUtils.getLoginToken();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("batch", CommonTools.writeObjectToJson(taskIds));
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("Content-Type", "json");
            headerParam.put("x-access-token", token);
            HttpResponse httpResponse = HttpUtils.doGet(hostUrl, BATCH_TASK_URL, headerParam, paramMap);
            HttpEntity entity = httpResponse.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
            this.logger.info("\u53d1\u7968\u8bc6\u522b\u7ed3\u679c\u67e5\u8be2\uff08\u83b7\u53d6\u8bc6\u522b\u4efb\u52a1(\u6279\u91cf)\uff09\u6210\u529f\uff1a" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u53d1\u7968\u8bc6\u522b\u7ed3\u679c\u67e5\u8be2\uff08\u83b7\u53d6\u8bc6\u522b\u4efb\u52a1(\u6279\u91cf)\uff09\u5931\u8d25\uff1a" + e.getMessage());
        }
        return CommonTools.getStr(Response.from(Response.OK, "\u53d1\u7968\u8bc6\u522b\u7ed3\u679c\u67e5\u8be2\uff08\u83b7\u53d6\u8bc6\u522b\u4efb\u52a1(\u6279\u91cf)\uff09\u67e5\u8be2\u6210\u529f", result));
    }
}

