/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.sap;

import com.xforceplus.vanke.sc.outer.api.imsApi.serving.cloud.ims.api.util.ApiMonitorUtil;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefp.v1.InvoiceStatusInfo;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.osb.BatchInfo;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.osb.BatchType;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.osb.RequestInfo;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.osb.RequestPubProfile;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.osb.SysValue;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.osb.Systems;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.pdc.settlementresult.v1.SettlementResultInfo;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.SRMREQUEST;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.SRMRESPONSE;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.SRMService;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.v1.BASEINFO;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.v1.MESSAGE;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.srm.srmservice.v1.RETURNSTATUS;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.base.DT_BASEINFO;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_INVOICESTATUS_REQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_INVOICESTATUS_REQI_REQUEST;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_INVOICESTATUS_REQI_REQUESTMESSAGEDATA;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_INVOICESTATUS_RSP;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_INVOICESTATUS_RSPE_RESPONSERETURNSTATUS;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_LEGALPERSONSTATUS_REQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_LEGALPERSONSTATUS_REQI_REQUEST;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.DT_PO_LEGALPERSONSTATUS_REQI_REQUESTMESSAGEDATA;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.SI_PO_INVOICESTATUS_OUT_SYNBindingStub;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.SI_PO_INVOICESTATUS_OUT_SYNServiceLocator;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.SI_PO_LEGALPERSONSTATUS_OUT_ASYBindingStub;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.SI_PO_LEGALPERSONSTATUS_OUT_ASYServiceLocator;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.DT_PO_SETTLEMENTXYJSTA_REQ;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.DT_PO_SETTLEMENTXYJSTA_REQI_REQUEST;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.DT_PO_SETTLEMENTXYJSTA_REQI_REQUESTMESSAGE;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.DT_PO_SETTLEMENTXYJSTA_REQI_REQUESTMESSAGEDATA;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.DT_PO_SETTLEMENTXYJSTA_RSP;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.SI_PO_SETTLEMENTXYJSTA_OUT_SYNBindingStub;
import com.xforceplus.vanke.sc.outer.api.imsApi.vk.po.invoice.XYJSTA.SI_PO_SETTLEMENTXYJSTA_OUT_SYNServiceLocator;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.DateUtil;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.PropertieUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.rpc.ServiceException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SAPInterfaceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAPInterfaceImpl.class);
    private static final String S_SYSTEM = PropertieUtil.sapS_System;
    private static final String T_SYSTEM = PropertieUtil.sapT_System;
    private static final String R_SYSTEM = PropertieUtil.sapR_System;
    private static final String COMPANY_INFO_ADDRESS = PropertieUtil.sapOsbCompanyInfoUrl;
    private static final String RECEIVE_SYSTEM_NAME = "B2B-SRM";
    private static final String RECEIVE_SYSTEM_NUMBER = "03006";
    private static final String REQUEST_SYSTEM_NAME = "FP";
    private static final String REQUEST_SYSTEM_NUMBER = "08006";
    private static String REQUEST_ID = DateUtil.getDateShortString(new Date()) + "08006";

    public String settlementResult(SettlementResultInfo settlementInfo) {
        String jsonStr = "";
        String originSystem = "SAP";
        try {
            if (null == settlementInfo) {
                return jsonStr;
            }
            DT_BASEINFO baseInfo = SAPInterfaceImpl.getBaseInfo("SETTLEMENTXYJSTA");
            if (baseInfo.getS_SYSTEM().equals(R_SYSTEM)) {
                originSystem = "SRM";
                baseInfo.setT_SYSTEM(R_SYSTEM);
            }
            DT_PO_SETTLEMENTXYJSTA_REQI_REQUESTMESSAGEDATA data = new DT_PO_SETTLEMENTXYJSTA_REQI_REQUESTMESSAGEDATA();
            data.setInfo(settlementInfo.getInfo());
            String settlementNo = settlementInfo.getSettlementNo();
            data.setSettlementNo(settlementNo);
            data.setStatus(settlementInfo.getStatus());
            DT_PO_SETTLEMENTXYJSTA_REQI_REQUESTMESSAGE message = new DT_PO_SETTLEMENTXYJSTA_REQI_REQUESTMESSAGE(data);
            DT_PO_SETTLEMENTXYJSTA_REQI_REQUEST iRequest = new DT_PO_SETTLEMENTXYJSTA_REQI_REQUEST(baseInfo, message);
            DT_PO_SETTLEMENTXYJSTA_REQ request = new DT_PO_SETTLEMENTXYJSTA_REQ(iRequest);
            SI_PO_SETTLEMENTXYJSTA_OUT_SYNServiceLocator locator = new SI_PO_SETTLEMENTXYJSTA_OUT_SYNServiceLocator();
            SI_PO_SETTLEMENTXYJSTA_OUT_SYNBindingStub stub = (SI_PO_SETTLEMENTXYJSTA_OUT_SYNBindingStub)locator.getHTTP_Port();
            stub.setUsername(PropertieUtil.sapUserName);
            stub.setPassword(PropertieUtil.sapPassword);
            LOGGER.info("\u8c03\u7528\u4e07\u79d1\u3010\u534f\u540c\u7ed3\u7b97\u5355\u53cd\u9988\u3011\u63a5\u53e3\u8bf7\u6c42\uff1a{}", (Object)JSONObject.fromObject((Object)request).toString());
            DT_PO_SETTLEMENTXYJSTA_RSP response = stub.SI_PO_SETTLEMENTXYJSTA_OUT_SYN(request);
            jsonStr = ApiMonitorUtil.toJSONString(response.getE_RESPONSE().getRETURNSTATUS());
            LOGGER.info("\u8c03\u7528\u4e07\u79d1\u3010\u534f\u540c\u7ed3\u7b97\u5355\u53cd\u9988\u3011\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)jsonStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(originSystem + "\u534f\u540c\u7ed3\u7b97\u5355\u53cd\u9988\u63a5\u53e3 - \u8bf7\u6c42\u5f02\u5e38\u54cd\u5e94: [{}]", (Object)e.getMessage());
        }
        return jsonStr;
    }

    public JSONArray invoiceStatusResults(List<InvoiceStatusInfo> invoiceResults) {
        JSONArray jsonArray = null;
        DT_BASEINFO baseinfo = SAPInterfaceImpl.getBaseInfo("INVOICESTATUS");
        DT_PO_INVOICESTATUS_REQI_REQUESTMESSAGEDATA[] messages = new DT_PO_INVOICESTATUS_REQI_REQUESTMESSAGEDATA[invoiceResults.size()];
        DT_PO_INVOICESTATUS_REQI_REQUESTMESSAGEDATA data = null;
        for (int i = 0; i < invoiceResults.size(); ++i) {
            InvoiceStatusInfo invoice = invoiceResults.get(i);
            data = new DT_PO_INVOICESTATUS_REQI_REQUESTMESSAGEDATA(invoice.getInvoiceType(), invoice.getInvoiceNo(), invoice.getInvoiceCode(), invoice.getPaperDrewDate(), invoice.getAmountWithoutTax(), invoice.getTaxAmount(), invoice.getAmountWithTax(), invoice.getStatus(), invoice.getSettlementNo(), invoice.getOriginInvoiceNo(), invoice.getOriginInvoiceCode(), invoice.getRedNotificationNo(), invoice.getReserve1(), invoice.getReserve2(), invoice.getReserve3(), invoice.getReserve4(), invoice.getReserve5());
            LOGGER.info("##################################### \u8c03\u7528SAP\u3010\u53d1\u7968\u4fe1\u606f\u53cd\u9988SAP\u3011\u8bf7\u6c42\u4fe1\u606f: {} #####################################", (Object)data.toString());
            messages[i] = data;
        }
        DT_PO_INVOICESTATUS_REQI_REQUEST i_REQUEST = new DT_PO_INVOICESTATUS_REQI_REQUEST(baseinfo, messages);
        DT_PO_INVOICESTATUS_REQ rq = new DT_PO_INVOICESTATUS_REQ(i_REQUEST);
        try {
            SI_PO_INVOICESTATUS_OUT_SYNServiceLocator service = new SI_PO_INVOICESTATUS_OUT_SYNServiceLocator();
            SI_PO_INVOICESTATUS_OUT_SYNBindingStub so = (SI_PO_INVOICESTATUS_OUT_SYNBindingStub)service.getHTTP_Port();
            so.setUsername(PropertieUtil.sapUserName);
            so.setPassword(PropertieUtil.sapPassword);
            DT_PO_INVOICESTATUS_RSP rs = so.SI_PO_INVOICESTATUS_OUT_SYN(rq);
            DT_PO_INVOICESTATUS_RSPE_RESPONSERETURNSTATUS[] result = rs.getE_RESPONSE().getRETURNSTATUS();
            if (null != result && 0 < result.length) {
                jsonArray = JSONArray.fromObject((Object)result);
            }
            LOGGER.info("##################################### \u53d1\u7968\u4fe1\u606f\uff0c\u5ba1\u6838\u4fe1\u606f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u63a8\u9001SAP\u63a5\u53e3\u6210\u529f\u54cd\u5e94: {} #####################################", (Object)jsonArray.toString());
        }
        catch (ServiceException e) {
            LOGGER.error("##################################### \u53d1\u7968\u4fe1\u606f\uff0c\u5ba1\u6838\u4fe1\u606f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u63a8\u9001SAP\u63a5\u53e3\u5f02\u5e38\u54cd\u5e94: {} #####################################", (Object)e.getMessage());
            e.printStackTrace();
        }
        catch (RemoteException e) {
            LOGGER.error("##################################### \u53d1\u7968\u4fe1\u606f\uff0c\u5ba1\u6838\u4fe1\u606f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u63a8\u9001SAP\u63a5\u53e3\u5f02\u5e38\u54cd\u5e94: {} #####################################", (Object)e.getMessage());
            e.printStackTrace();
        }
        return jsonArray;
    }

    public static DT_BASEINFO getBaseInfo(String serviceName) {
        DT_BASEINFO baseInfo = new DT_BASEINFO();
        baseInfo.setMSGID(UUID.randomUUID().toString().replaceAll("-", ""));
        baseInfo.setS_SYSTEM(S_SYSTEM);
        baseInfo.setSENDTIME(DateUtil.getNowTimeShortString());
        baseInfo.setSERVICENAME(serviceName);
        baseInfo.setT_SYSTEM(T_SYSTEM);
        baseInfo.setRETRY("1");
        return baseInfo;
    }

    public void legalPersonReceiveResult(String number, String status, String info) {
        JSONObject json = new JSONObject();
        json.put((Object)"number", (Object)number);
        json.put((Object)"status", (Object)status);
        json.put((Object)"info", (Object)info);
        try {
            DT_BASEINFO baseinfo = SAPInterfaceImpl.getBaseInfo("LEGALPERSONSTATUS");
            DT_PO_LEGALPERSONSTATUS_REQI_REQUESTMESSAGEDATA message = new DT_PO_LEGALPERSONSTATUS_REQI_REQUESTMESSAGEDATA(number, status, info);
            DT_PO_LEGALPERSONSTATUS_REQI_REQUESTMESSAGEDATA[] messages = new DT_PO_LEGALPERSONSTATUS_REQI_REQUESTMESSAGEDATA[]{message};
            DT_PO_LEGALPERSONSTATUS_REQI_REQUEST request = new DT_PO_LEGALPERSONSTATUS_REQI_REQUEST(baseinfo, messages);
            DT_PO_LEGALPERSONSTATUS_REQ rq = new DT_PO_LEGALPERSONSTATUS_REQ(request);
            SI_PO_LEGALPERSONSTATUS_OUT_ASYServiceLocator service = new SI_PO_LEGALPERSONSTATUS_OUT_ASYServiceLocator();
            SI_PO_LEGALPERSONSTATUS_OUT_ASYBindingStub so = (SI_PO_LEGALPERSONSTATUS_OUT_ASYBindingStub)service.getHTTP_Port();
            so.setUsername(PropertieUtil.sapUserName);
            so.setPassword(PropertieUtil.sapPassword);
            so.SI_PO_LEGALPERSONSTATUS_OUT_ASY(rq);
            LOGGER.info("------------------------------------ \u8c03\u7528\u6cd5\u4eba\u4e3b\u6570\u636e[\u559c\u76c8\u4f73]\u53cd\u9988\u56de\u4f20SAP - \u8bf7\u6c42\u6210\u529f ------------------------------------");
        }
        catch (Exception e) {
            LOGGER.error("##################################### \u8c03\u7528\u6cd5\u4eba\u4e3b\u6570\u636e[\u559c\u76c8\u4f73]\u53cd\u9988\u56de\u4f20SAP - \u8bf7\u6c42\u5f02\u5e38\u54cd\u5e94: {} #####################################", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public String companyInfoDataResult(Map<String, Object> params, String request_Id) {
        String jsonStr = "";
        try {
            JSONObject json = JSONObject.fromObject(params);
            LOGGER.info("PDC\u4f9b\u5e94\u5546\u4fe1\u606f[\u559c\u76c8\u4f73]\u53cd\u9988 - \u8bf7\u6c42\u4fe1\u606f: [{}]", (Object)json);
            JaxWsProxyFactoryBean bean = new JaxWsProxyFactoryBean();
            bean.setAddress(COMPANY_INFO_ADDRESS);
            bean.setServiceClass(SRMService.class);
            SRMService srmService = (SRMService)bean.create();
            BASEINFO baseInfo = new BASEINFO();
            baseInfo.setMSGID(UUID.randomUUID().toString().replaceAll("-", ""));
            baseInfo.setSSYSTEM(S_SYSTEM);
            baseInfo.setSENDTIME(DateUtil.getNowTimeShortString());
            baseInfo.setSERVICENAME("invoiceManagePlatformStatus");
            baseInfo.setTSYSTEM(T_SYSTEM);
            baseInfo.setRETRY("1");
            MESSAGE message = new MESSAGE();
            message.setDATA(json.toString());
            RequestPubProfile requestPubProfile = new RequestPubProfile();
            RequestInfo requestInfo = new RequestInfo();
            requestInfo.setCorrelationID("0");
            requestInfo.setRequestID(REQUEST_ID + request_Id);
            requestInfo.setVersion("1.0");
            requestPubProfile.setRequestInfo(requestInfo);
            BatchType batchType = new BatchType();
            BatchInfo batchInfo = new BatchInfo();
            batchInfo.setDataCount(1);
            batchInfo.setDataName("SRM_REQUEST");
            batchType.setBatchInfo(batchInfo);
            Systems systems = new Systems();
            ArrayList<SysValue> system = new ArrayList<SysValue>();
            SysValue systemVal = new SysValue();
            systemVal.setSysName(RECEIVE_SYSTEM_NAME);
            systemVal.setValue(RECEIVE_SYSTEM_NUMBER);
            system.add(0, systemVal);
            systems.setSystem(system);
            SysValue source = new SysValue();
            source.setSysName(REQUEST_SYSTEM_NAME);
            source.setValue(REQUEST_SYSTEM_NUMBER);
            systems.setSource(source);
            SRMREQUEST request = new SRMREQUEST();
            request.setBASEINFO(baseInfo);
            request.setBatchType(batchType);
            request.setMESSAGE(message);
            request.setRequestPubProfile(requestPubProfile);
            request.setSystems(systems);
            SRMRESPONSE response = srmService.srmOperation(request);
            RETURNSTATUS rs = response.getRETURNSTATUS();
            jsonStr = ApiMonitorUtil.toJSONString(rs);
            LOGGER.info("SAP\u4f9b\u5e94\u5546\u4fe1\u606f[\u559c\u76c8\u4f73]\u53cd\u9988 - \u8bf7\u6c42\u6210\u529f: [{}]", (Object)jsonStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("SAP\u4f9b\u5e94\u5546\u4fe1\u606f[\u559c\u76c8\u4f73]\u53cd\u9988 - \u8bf7\u6c42\u5f02\u5e38\u54cd\u5e94: [{}]", (Object)e.getMessage());
        }
        return jsonStr;
    }
}

