/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.base.enums.invoice;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public enum AuthStatusEnum {
    DEFAULT(0, "--", 0),
    CAN_NOT_AUTH(1, "\u4e0d\u53ef\u52fe\u9009", null),
    NOT_AUTH(2, "\u672a\u52fe\u9009", 2),
    IN_AUTH(3, "\u52fe\u9009\u4e2d", 3),
    SUCCEED(4, "\u5df2\u786e\u8ba4\u62b5\u6263", null),
    FAILED(5, "\u52fe\u9009\u5931\u8d25", -1),
    ABNORMAL(6, "\u62b5\u6263\u5f02\u5e38", null),
    CHECKED(7, "\u5df2\u52fe\u9009", 1),
    RE_CHECKING(8, "\u64a4\u9500\u52fe\u9009\u4e2d", null),
    CHECK_ABNORMAL(9, "\u52fe\u9009\u5f02\u5e38", null);

    private Integer code;
    private String name;
    private Integer gxCode;

    private AuthStatusEnum(Integer code, String name, Integer gxCode) {
        this.code = code;
        this.name = name;
        this.gxCode = gxCode;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getGxCode() {
        return this.gxCode;
    }

    public static List<Integer> getNotAuthList() {
        return Arrays.asList(NOT_AUTH.getCode(), FAILED.getCode());
    }

    public static List<Integer> getAuthSuccessList() {
        return Arrays.asList(SUCCEED.getCode(), ABNORMAL.getCode());
    }

    public static AuthStatusEnum fromCode(Integer code) {
        return Stream.of(AuthStatusEnum.values()).filter(t -> t.code.equals(code)).findFirst().orElse(null);
    }

    public static AuthStatusEnum fromGxCode(Integer gxCode) {
        return Stream.of(AuthStatusEnum.values()).filter(t -> t.gxCode != null && t.gxCode.equals(gxCode)).findFirst().orElse(null);
    }
}

