/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.base.config;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jms.core.JmsTemplate;

@Configuration
public class ActiveMqConfig {
    @Bean(name={"innerConnectionFactory"})
    @Primary
    public ActiveMQConnectionFactory firstConnectionFactory(@Value(value="${spring.inner.activemq.brokerUrl:}") String brokerUrl, @Value(value="${spring.inner.activemq.user:}") String username, @Value(value="${spring.inner.activemq.password:}") String password) {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(brokerUrl);
        factory.setUserName(username);
        factory.setPassword(password);
        return factory;
    }

    @Bean(name={"innerActivemqTemplate"})
    @Primary
    public JmsTemplate innerActivemqTemplate(@Qualifier(value="innerConnectionFactory") ActiveMQConnectionFactory connectionFactory) {
        JmsTemplate template = new JmsTemplate((ConnectionFactory)connectionFactory);
        return template;
    }

    @Bean(name={"saasConnectionFactory"})
    public ActiveMQConnectionFactory secondConnectionFactory(@Value(value="${spring.saas.activemq.brokerUrl:}") String brokerUrl, @Value(value="${spring.saas.activemq.user:}") String username, @Value(value="${spring.saas.activemq.password:}") String password) {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(brokerUrl);
        factory.setUserName(username);
        factory.setPassword(password);
        return factory;
    }

    @Bean(name={"sasaActivemqTemplate"})
    public JmsTemplate sasaActivemqTemplate(@Qualifier(value="saasConnectionFactory") ActiveMQConnectionFactory connectionFactory) {
        JmsTemplate template = new JmsTemplate((ConnectionFactory)connectionFactory);
        return template;
    }
}

