/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.api.imsCore.util.ip;

import com.xforceplus.vanke.sc.outer.api.imsCore.util.Util;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.ValidatorUtil;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.ip.IpEntry;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.ip.IpUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpSeeker {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpSeeker.class);
    private static final String IP_FILE = Util.getWebInfoRealPath() + "WEB-INF" + File.separator + "classes" + File.separator + "files" + File.separator + "qqwry.dat";
    private static final int IP_RECORD_LENGTH = 7;
    private static final byte AREA_FOLLOWED = 1;
    private static final byte NO_AREA = 2;
    private static ConcurrentHashMap<String, IpLocation> ipCache;
    private RandomAccessFile ipFile;
    private MappedByteBuffer mbb;
    private long ipBegin;
    private long ipEnd;
    private final IpLocation loc;
    private final byte[] buf;
    private final byte[] b4;
    private final byte[] b3;
    private static IpSeeker instance;

    private IpSeeker() {
        ipCache = new ConcurrentHashMap();
        this.loc = new IpLocation();
        this.buf = new byte[100];
        this.b4 = new byte[4];
        this.b3 = new byte[3];
        try {
            this.ipFile = new RandomAccessFile(IP_FILE, "r");
        }
        catch (FileNotFoundException e) {
            LOGGER.error("IP\u6570\u636e\u6587\u4ef6\u4e0d\u5b58\u5728,\u8bfb\u53d6\u5730\u5740:{}", (Object)IP_FILE, (Object)e);
            this.ipFile = null;
        }
        if (this.ipFile != null) {
            try {
                this.ipBegin = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipBegin == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                LOGGER.error("\u8bfb\u53d6IP\u6570\u636e\u6587\u4ef6\u5931\u8d25,\u8bfb\u53d6\u5730\u5740:{}", (Object)IP_FILE, (Object)e);
                this.ipFile = null;
            }
        }
    }

    public static IpSeeker getInstance() {
        return instance;
    }

    public List<IpEntry> getIpEntriesDebug(String s) {
        ArrayList<IpEntry> ret = new ArrayList<IpEntry>();
        long endOffset = this.ipEnd + 4L;
        for (long offset = this.ipBegin + 4L; offset <= endOffset; offset += 7L) {
            long temp = this.readLong3(offset);
            if (temp == -1L) continue;
            IpLocation loc = this.getIpLocation(temp);
            if (loc.country.indexOf(s) == -1 && loc.area.indexOf(s) == -1) continue;
            IpEntry entry = new IpEntry();
            entry.setCountry(loc.country);
            entry.setArea(loc.area);
            this.readIP(offset - 4L, this.b4);
            entry.setBeginIp(IpUtil.getIpStringFromBytes(this.b4));
            this.readIP(temp, this.b4);
            entry.setEndIp(IpUtil.getIpStringFromBytes(this.b4));
            ret.add(entry);
        }
        return ret;
    }

    public List<IpEntry> getIpEntries(String s) {
        ArrayList<IpEntry> ret = new ArrayList<IpEntry>();
        try {
            if (this.mbb == null) {
                FileChannel fc = this.ipFile.getChannel();
                this.mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.ipFile.length());
                this.mbb.order(ByteOrder.LITTLE_ENDIAN);
            }
            int endOffset = (int)this.ipEnd;
            for (int offset = (int)this.ipBegin + 4; offset <= endOffset; offset += 7) {
                int temp = this.readInt3(offset);
                if (temp == -1) continue;
                IpLocation loc = this.getIpLocation(temp);
                if (loc.country.indexOf(s) == -1 && loc.area.indexOf(s) == -1) continue;
                IpEntry entry = new IpEntry();
                entry.setCountry(loc.country);
                entry.setArea(loc.area);
                this.readIP(offset - 4, this.b4);
                entry.setBeginIp(IpUtil.getIpStringFromBytes(this.b4));
                this.readIP(temp, this.b4);
                entry.setEndIp(IpUtil.getIpStringFromBytes(this.b4));
                ret.add(entry);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u7ed9\u5b9a\u4e00\u4e2a\u5730\u70b9\u7684\u4e0d\u5b8c\u5168\u540d\u5b57\uff0c\u5f97\u5230\u4e00\u7cfb\u5217\u5305\u542bs\u5b50\u4e32\u7684IP\u8303\u56f4\u8bb0\u5f55\u5931\u8d25,\u5730\u70b9:{}", (Object)s, (Object)e);
        }
        return ret;
    }

    private int readInt3(int offset) {
        this.mbb.position(offset);
        return this.mbb.getInt() & 0xFFFFFF;
    }

    private int readInt3() {
        return this.mbb.getInt() & 0xFFFFFF;
    }

    public String getCountry(byte[] ip) {
        if (this.ipFile == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        String ipStr = IpUtil.getIpStringFromBytes(ip);
        if (ipCache.containsKey(ipStr)) {
            IpLocation loc = ipCache.get(ipStr);
            return loc.country;
        }
        IpLocation loc = this.getIpLocation(ip);
        ipCache.put(ipStr, loc.copyIpLocation());
        return loc.country;
    }

    public String getCountry(String ip) {
        return this.getCountry(IpUtil.getIpByteArrayFromString(ip));
    }

    public String getArea(byte[] ip) {
        if (this.ipFile == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        String ipStr = IpUtil.getIpStringFromBytes(ip);
        if (ipCache.containsKey(ipStr)) {
            IpLocation loc = ipCache.get(ipStr);
            return loc.area;
        }
        IpLocation loc = this.getIpLocation(ip);
        ipCache.put(ipStr, loc.copyIpLocation());
        return loc.area;
    }

    public String getArea(String ip) {
        return this.getArea(IpUtil.getIpByteArrayFromString(ip));
    }

    private IpLocation getIpLocation(byte[] ip) {
        IpLocation info = null;
        long offset = this.locateIp(ip);
        if (offset != -1L) {
            info = this.getIpLocation(offset);
        }
        if (info == null) {
            info = new IpLocation();
            info.country = "\u672a\u77e5\u56fd\u5bb6";
            info.area = "\u672a\u77e5\u5730\u533a";
        }
        return info;
    }

    private long readLong4(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            ret |= (long)(this.ipFile.readByte() & 0xFF);
            ret |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            ret |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return ret |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long ret = 0L;
        try {
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readIP(long offset, byte[] ip) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ip);
            byte temp = ip[0];
            ip[0] = ip[3];
            ip[3] = temp;
            temp = ip[1];
            ip[1] = ip[2];
            ip[2] = temp;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private void readIP(int offset, byte[] ip) {
        this.mbb.position(offset);
        this.mbb.get(ip);
        byte temp = ip[0];
        ip[0] = ip[3];
        ip[3] = temp;
        temp = ip[1];
        ip[1] = ip[2];
        ip[2] = temp;
    }

    private int compareIp(byte[] ip, byte[] beginIp) {
        for (int i = 0; i < 4; ++i) {
            int r = this.compareByte(ip[i], beginIp[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    private int compareByte(byte b1, byte b2) {
        if ((b1 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        if ((b1 ^ b2) == 0) {
            return 0;
        }
        return -1;
    }

    private long locateIp(byte[] ip) {
        long m = 0L;
        this.readIP(this.ipBegin, this.b4);
        int r = this.compareIp(ip, this.b4);
        if (r == 0) {
            return this.ipBegin;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipBegin;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIp(ip, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIp(ip, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private IpLocation getIpLocation(long offset) {
        try {
            this.ipFile.seek(offset + 4L);
            byte b = this.ipFile.readByte();
            if (b == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                b = this.ipFile.readByte();
                if (b == 2) {
                    this.loc.country = this.readString(this.readLong3());
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.loc.country = this.readString(countryOffset);
                }
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            } else if (b == 2) {
                this.loc.country = this.readString(this.readLong3());
                this.loc.area = this.readArea(offset + 8L);
            } else {
                this.loc.country = this.readString(this.ipFile.getFilePointer() - 1L);
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            }
            return this.loc;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IpLocation getIpLocation(int offset) {
        this.mbb.position(offset + 4);
        byte b = this.mbb.get();
        if (b == 1) {
            int countryOffset = this.readInt3();
            this.mbb.position(countryOffset);
            b = this.mbb.get();
            if (b == 2) {
                this.loc.country = this.readString(this.readInt3());
                this.mbb.position(countryOffset + 4);
            } else {
                this.loc.country = this.readString(countryOffset);
            }
            this.loc.area = this.readArea(this.mbb.position());
        } else if (b == 2) {
            this.loc.country = this.readString(this.readInt3());
            this.loc.area = this.readArea(offset + 8);
        } else {
            this.loc.country = this.readString(this.mbb.position() - 1);
            this.loc.area = this.readArea(this.mbb.position());
        }
        return this.loc;
    }

    private String readArea(long offset) throws IOException {
        this.ipFile.seek(offset);
        byte b = this.ipFile.readByte();
        if (b == 1 || b == 2) {
            long areaOffset = this.readLong3(offset + 1L);
            if (areaOffset == 0L) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readArea(int offset) {
        this.mbb.position(offset);
        byte b = this.mbb.get();
        if (b == 1 || b == 2) {
            int areaOffset = this.readInt3();
            if (areaOffset == 0) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            this.buf[i] = this.ipFile.readByte();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.ipFile.readByte();
            }
            if (i != 0) {
                return IpUtil.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return "";
    }

    private String readString(int offset) {
        try {
            this.mbb.position(offset);
            int i = 0;
            this.buf[i] = this.mbb.get();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.mbb.get();
            }
            if (i != 0) {
                return IpUtil.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        return "";
    }

    public String getAddress(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return "";
        }
        if (ValidatorUtil.validateIp(ip)) {
            String country = this.getCountry(ip).equals(" CZ88.NET") ? "" : this.getCountry(ip);
            String area = this.getArea(ip).equals(" CZ88.NET") ? "" : this.getArea(ip);
            String address = country + " " + area;
            return address.trim();
        }
        return "";
    }

    static {
        instance = new IpSeeker();
    }

    private class IpLocation {
        public String country = "";
        public String area = "";

        public IpLocation copyIpLocation() {
            IpLocation ret = new IpLocation();
            ret.country = this.country;
            ret.area = this.area;
            return ret;
        }
    }
}

