/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.api.imsCore.util.ip;

import com.xforceplus.vanke.sc.outer.api.imsCore.util.ip.IpSeeker;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public final class IpUtil {
    private IpUtil() {
    }

    public static String getRequestIP(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (StringUtils.isNotBlank((CharSequence)ip) && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public static byte[] getIpByteArrayFromString(String ip) {
        byte[] ret = new byte[4];
        StringTokenizer st = new StringTokenizer(ip, ".");
        ret[0] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
        ret[1] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
        ret[2] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
        ret[3] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
        return ret;
    }

    public static String getString(String str, String srcEncoding, String destEncoding) {
        try {
            return new String(str.getBytes(srcEncoding), destEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String getString(byte[] b, String encoding) {
        try {
            return new String(b, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(b);
        }
    }

    public static String getString(byte[] b, int offset, int len, String encoding) {
        try {
            return new String(b, offset, len, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(b, offset, len);
        }
    }

    public static String getIpStringFromBytes(byte[] ip) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip[0] & 0xFF);
        sb.append('.');
        sb.append(ip[1] & 0xFF);
        sb.append('.');
        sb.append(ip[2] & 0xFF);
        sb.append('.');
        sb.append(ip[3] & 0xFF);
        return sb.toString();
    }

    public static void main(String[] args) {
        IpSeeker ipSeeker = IpSeeker.getInstance();
        String address = ipSeeker.getAddress("103.228.209.158");
        System.out.println(address);
    }
}

