/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.api.imsCore.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTools {
    private static Logger logger = LoggerFactory.getLogger(CommonTools.class);

    public static String getStr(Object obj) {
        if (obj != null) {
            return obj.toString().trim();
        }
        return "";
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        if (str.trim().length() == 0) {
            return true;
        }
        return str.trim().equalsIgnoreCase("null");
    }

    public static boolean isEmpty(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static void copyProperties(Object orig, Object dest) {
        BeanUtilsBean beanUtilsBean = new BeanUtilsBean();
        beanUtilsBean.getConvertUtils().register((Converter)new BigDecimalConverter(null), BigDecimal.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlTimestampConverter(null), Timestamp.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlDateConverter(null), Date.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlTimeConverter(null), Time.class);
        try {
            beanUtilsBean.copyProperties(dest, orig);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Map writeJsonToMap(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        Map map = null;
        try {
            map = (Map)mapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            logger.error("\u4f20\u8f93\u6570\u636e\u9519\u8bef!", (Throwable)e);
            throw new Exception("\u4f20\u8f93\u6570\u636e\u9519\u8bef!");
        }
        return map;
    }

    public static String writeMapToJson(Map map) {
        String result = "";
        try {
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
            result = jsonObject.toString();
        }
        catch (Exception e) {
            logger.error("Map\u8f6c\u6362JSON\u5b57\u7b26\u4e32\u9519\u8bef!", (Throwable)e);
        }
        return result;
    }

    public static <T> T writeJsonToObject(String json, Class<T> t) {
        Object instance = null;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            instance = objectMapper.readValue(json, t);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)instance;
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static String writeObjectToJson(Object o) {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonStr = "";
        try {
            jsonStr = objectMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.error("Map\u5e8f\u5217\u5316\u9519\u8bef " + e.getMessage(), (Throwable)e);
        }
        return jsonStr;
    }

    public static String DateParse(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        java.util.Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        sdf = new SimpleDateFormat("yyyy-MM-dd");
        str = sdf.format(date);
        return str;
    }

    public static String getMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        java.util.Date now = new java.util.Date();
        String nowString = sdf.format(now);
        return nowString;
    }

    public static String getData17() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        java.util.Date now = new java.util.Date();
        String nowString = sdf.format(now);
        return nowString;
    }

    public static String date() throws Exception {
        Thread.sleep(3L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String format = sdf.format(new java.util.Date());
        return format;
    }

    public static String getStrToBig(String str) {
        BigDecimal bd = new BigDecimal(str);
        bd = bd.setScale(2, 4);
        String outString = bd.toString();
        return outString;
    }

    public static boolean compareBigZero(String str) {
        boolean bool = false;
        BigDecimal bd = new BigDecimal(str);
        if ((bd = bd.setScale(2, 4)).compareTo(new BigDecimal(BigInteger.ZERO)) == -1) {
            bool = true;
        }
        return bool;
    }

    public static boolean compareBig(String str1, String str2) {
        boolean bool = false;
        BigDecimal bd1 = new BigDecimal(str1);
        bd1 = bd1.setScale(2, 4);
        BigDecimal bd2 = new BigDecimal(str2);
        if (bd1.compareTo(bd2 = bd2.setScale(2, 4)) == 0) {
            bool = true;
        }
        return bool;
    }

    public static String millisecondToDate(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        long now = Long.parseLong(str);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(now);
        String date = formatter.format(calendar.getTime());
        return date;
    }

    public static String millisecondToDatedd(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        long now = Long.parseLong(str);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(now);
        String date = formatter.format(calendar.getTime());
        return date;
    }

    public static Object mapToObject(Map map, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            field.set(obj, map.get(field.getName()));
        }
        return obj;
    }

    public static Map<String, Object> objectToMap(Object obj) throws Exception {
        Field[] declaredFields;
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(obj));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String getFileToName(String url) {
        String name = "";
        try {
            int index = url.lastIndexOf(".");
            name = url.substring(index, url.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getDateFile() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        int day = cale.get(5);
        return "/" + year + "/" + month + "/" + day + "/";
    }
}

