/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.base.enums.invoice;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public enum AuthStyleEnum {
    DEFAULT(0, "--"),
    PYT_ACCOUNT_CONFIRM(10, "\u5e95\u8d26\u62b5\u6263"),
    PYT_SCAN_CERTIFY(20, "\u626b\u63cf\u62b5\u6263"),
    PYT_ACCOUNT_CERTIFY_IMPORT(11, "\u5e95\u8d26\u62b5\u6263\u5bfc\u5165"),
    PYT_SCAN_CERTIFY_IMPORT(21, "\u626b\u63cf\u62b5\u6263\u5bfc\u5165"),
    NATIONALTAX_ACCOUNT_CONFIRM(12, "\u56fd\u7a0e\u5e95\u8d26\u62b5\u6263"),
    NATIONALTAX_SCAN_CERTIFY(22, "\u56fd\u7a0e\u626b\u63cf\u62b5\u6263");

    private Integer code;
    private String name;

    private AuthStyleEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static List<Integer> scanAuthList() {
        return Arrays.asList(PYT_SCAN_CERTIFY.getCode(), PYT_SCAN_CERTIFY_IMPORT.getCode(), NATIONALTAX_SCAN_CERTIFY.getCode());
    }

    public static List<Integer> accountAuthList() {
        return Arrays.asList(PYT_ACCOUNT_CONFIRM.getCode(), PYT_ACCOUNT_CERTIFY_IMPORT.getCode(), NATIONALTAX_ACCOUNT_CONFIRM.getCode());
    }

    public static AuthStyleEnum fromCode(Integer code) {
        return Stream.of(AuthStyleEnum.values()).filter(t -> t.code.equals(code)).findFirst().orElse(null);
    }
}

