/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.api.imsCore.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final String TIME_FORMAT_SHORT = "yyyyMMddHHmmss";
    private static final String TIME_FORMAT_NORMAL = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_FORMAT_NORMAL_MILLISECOND = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final String TIME_FORMAT_ENGLISH = "MM/dd/yyyy HH:mm:ss";
    private static final String TIME_FORMAT_CHINA = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    private static final String TIME_FORMAT_CHINA_S = "yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2";
    private static final String TIME_FORMAT_SHORT_S = "HH:mm:ss";
    public static final String TIME_FORMAT_SHORT_M = "HH:mm";
    private static final String DATE_FORMAT_SHORT = "yyyyMMdd";
    private static final String DATE_FORMAT_NORMAL = "yyyy-MM-dd";
    private static final String DATE_FORMAT_ENGLISH = "MM/dd/yyyy";
    public static final String DATE_FORMAT_CHINA = "yyyy\u5e74MM\u6708dd\u65e5";
    private static final String MONTH_FORMAT = "yyyyMM";
    private static final String YEAR_MONTH_FORMAT = "yyyy-MM";
    private static final String DATE_FORMAT_MINUTE = "yyyyMMddHHmm";
    private static final String MONTH_DAY_FORMAT = "MM-dd";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date changeDate(Date originDate, int field, int distance) {
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTime(originDate);
        c.add(field, distance);
        return c.getTime();
    }

    public static Date convertAsDate(String dateStr) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat fmt = null;
        if (dateStr.matches("\\d{14}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_SHORT);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}:\\d{1,3}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL_MILLISECOND);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{1,3}")) {
            dateStr = dateStr.replace(".", ":");
            fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL_MILLISECOND);
        } else if (dateStr.matches("\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_ENGLISH);
        } else if (dateStr.matches("\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_CHINA);
        } else if (dateStr.matches("\\d{8}")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_SHORT);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_NORMAL);
        } else if (dateStr.matches("\\d{1,2}/\\d{1,2}/\\d{4}")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_ENGLISH);
        } else if (dateStr.matches("\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_CHINA);
        } else if (dateStr.matches("\\d{4}\\d{1,2}\\d{1,2}\\d{1,2}\\d{1,2}")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_MINUTE);
        } else if (dateStr.matches("\\d{1,2}:\\d{1,2}:\\d{1,2}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_SHORT_S);
        } else {
            return null;
        }
        try {
            return fmt.parse(dateStr);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("Date or Time String is invalid.");
        }
    }

    public static String convertAsShortDateString(String origin) {
        return origin == null ? origin : origin.replaceAll("[-|:|\\s|\u5e74|\u6708|\u65e5|\u65f6|\u5206|\u79d2|/]", "");
    }

    public static String convertAsNormalDateString(String origin) {
        if (origin == null) {
            return origin;
        }
        try {
            if (origin.matches("\\d{8}")) {
                SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT_SHORT);
                return DateUtil.getDateNormalString(fmt.parse(origin));
            }
            if (origin.matches("\\d{14}")) {
                SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_SHORT);
                return DateUtil.getTimeNormalString(fmt.parse(origin));
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException(origin + "is invalid,String format is yyyyMMddHHmmss or yyyyMMdd");
    }

    public static String getDateChinaString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT_CHINA);
        return fmt.format(date);
    }

    public static String getDateEnglishString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT_ENGLISH);
        return fmt.format(date);
    }

    public static String getDateNormalString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT_NORMAL);
        return fmt.format(date);
    }

    public static String getMonthDayDateNormalString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(MONTH_DAY_FORMAT);
        return fmt.format(date);
    }

    public static String getYearMonthString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(YEAR_MONTH_FORMAT);
        return fmt.format(date);
    }

    public static String getNowYearMonthString() {
        return DateUtil.getYearMonthString(new Date());
    }

    public static String getDateShortString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT_SHORT);
        return fmt.format(date);
    }

    public static String getNowDateChinaString() {
        return DateUtil.getDateChinaString(new Date());
    }

    public static String getNowDateEnglishString() {
        return DateUtil.getDateEnglishString(new Date());
    }

    public static String getNowDateNormalString() {
        return DateUtil.getDateNormalString(new Date());
    }

    public static String getNowDateNormalString(int interval) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, interval);
        return DateUtil.getDateNormalString(c.getTime());
    }

    public static String getNowMonthNormalString(int interval) {
        return DateUtil.getNowDateNormalString(interval).substring(5, 10);
    }

    public static String getIntervalDaysLater(String day, int interval) {
        if (day == null || "".equals(day)) {
            return "";
        }
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(sdf.parse(day));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.add(5, interval);
        return DateUtil.getDateNormalString(c.getTime());
    }

    public static String getNowDateIntervalDaysLater(int interval) {
        return DateUtil.getIntervalDaysLater(DateUtil.getNowDateNormalString(), interval);
    }

    public static String getIntervalMonthLater(String day, int interval) {
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(sdf.parse(day));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.add(2, interval);
        return DateUtil.getDateNormalString(c.getTime());
    }

    public static String getNowMonthDayDateNormalString(int interval) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, interval);
        return DateUtil.getMonthDayDateNormalString(c.getTime());
    }

    public static String getNowDateShortString() {
        return DateUtil.getDateShortString(new Date());
    }

    public static String getNowTimeChinaString() {
        return DateUtil.getTimeChinaString(new Date());
    }

    public static String getNowTimeNormalStringS() {
        return DateUtil.getTimeNormalStringS(new Date());
    }

    public static String getNowTimeEnglishString() {
        return DateUtil.getTimeEnglishString(new Date());
    }

    public static String getCurrentTime() {
        return DateUtil.getTimeNormalString(new Date());
    }

    public static String getNowTimeShortString() {
        return DateUtil.getTimeShortString(new Date());
    }

    public static String getTimeChinaString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_CHINA);
        return fmt.format(date);
    }

    public static String getTimeChinaStringS(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_CHINA_S);
        return fmt.format(date);
    }

    public static String getTimeEnglishString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_ENGLISH);
        return fmt.format(date);
    }

    public static String getTimeNormalString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL);
        return fmt.format(date);
    }

    public static String getTimeNormalStringS(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_SHORT_S);
        return fmt.format(date);
    }

    public static String getTimeShortString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_SHORT);
        return fmt.format(date);
    }

    public static String getMonthString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(MONTH_FORMAT);
        return fmt.format(date);
    }

    public static String getMonthDay(int day) {
        SimpleDateFormat fmt = new SimpleDateFormat("M\u6708d\u65e5");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, day);
        return fmt.format(c.getTime());
    }

    public static List<String> getDateList(String beginDate, String endDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NORMAL);
        ArrayList<String> list = new ArrayList<String>();
        Calendar c1 = Calendar.getInstance(Locale.CHINA);
        c1.setTime(sdf.parse(beginDate));
        Calendar c2 = Calendar.getInstance(Locale.CHINA);
        c2.setTime(sdf.parse(endDate));
        long l1 = c1.getTimeInMillis();
        long l2 = c2.getTimeInMillis();
        int interval = (int)((l2 - l1) / 86400000L);
        for (int i = 0; i <= interval; ++i) {
            Calendar c = Calendar.getInstance();
            c.setTime(c1.getTime());
            c.add(5, i);
            list.add(sdf.format(c.getTime()));
        }
        return list;
    }

    public static String getFirstDayOfWeek(String day) throws ParseException {
        Calendar c1 = Calendar.getInstance(Locale.CHINA);
        c1.setTime(sdf.parse(day));
        c1.setFirstDayOfWeek(2);
        c1.set(7, c1.getFirstDayOfWeek());
        return sdf.format(c1.getTime());
    }

    public static String getLastDayOfWeek(String day) throws ParseException {
        Calendar c1 = Calendar.getInstance(Locale.CHINA);
        c1.setTime(sdf.parse(day));
        c1.setFirstDayOfWeek(2);
        c1.set(7, c1.getFirstDayOfWeek() + 6);
        return sdf.format(c1.getTime());
    }

    public static String getLastDayOfMonth(String day) throws ParseException {
        Calendar c1 = Calendar.getInstance(Locale.CHINA);
        c1.setTime(sdf.parse(day));
        c1.set(5, 1);
        c1.add(2, 1);
        c1.add(5, -1);
        return sdf.format(c1.getTime());
    }

    public static String getFirstDayOfMonth(String day) throws ParseException {
        Calendar c1 = Calendar.getInstance(Locale.CHINA);
        c1.setTime(sdf.parse(day));
        c1.set(5, 1);
        return sdf.format(c1.getTime());
    }

    public static boolean isFirstDayOfMonth(String day) throws ParseException {
        return day.equals(DateUtil.getFirstDayOfMonth(day));
    }

    public static boolean isLastDayOfMonth(String day) throws ParseException {
        return day.equals(DateUtil.getLastDayOfMonth(day));
    }

    public static boolean isFirstDayOfWeek(String day) throws ParseException {
        return day.equals(DateUtil.getFirstDayOfWeek(day));
    }

    public static boolean isLastDayOfWeek(String day) throws ParseException {
        return day.equals(DateUtil.getLastDayOfWeek(day));
    }

    public static boolean isDayBetweenMonthAndWeek(String day) throws ParseException {
        String firstDayOfMonth = DateUtil.getFirstDayOfMonth(day);
        String firstDayOfWeek = DateUtil.getFirstDayOfWeek(day);
        Pattern p = Pattern.compile("\\d{4}-\\d{2}-01");
        Matcher m = p.matcher(day);
        return firstDayOfWeek.compareTo(firstDayOfMonth) < 0 && !m.matches();
    }

    public static boolean isInputDate(String input) {
        return input.matches("\\d{4}-\\d{1,2}-\\d{1,2}");
    }

    public static boolean isInputDateNormalString(String input) {
        return input.matches("\\d{4}-\\d{2}-\\d{2}");
    }

    public static String formatDateString(String input) throws IllegalArgumentException {
        String month = "";
        String day = "";
        try {
            if (!DateUtil.isInputDate(input)) {
                throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5");
            }
            if (DateUtil.isInputDateNormalString(input)) {
                return input;
            }
            month = input.substring(input.indexOf("-") + 1, input.lastIndexOf("-"));
            if (month.length() == 1 && month.indexOf("0") != 0) {
                month = "0" + month;
            }
            if ((day = input.substring(input.lastIndexOf("-") + 1, input.length())).length() == 1 && day.indexOf("0") != 0) {
                day = "0" + day;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
        return input.substring(0, 4) + "-" + month + "-" + day;
    }

    public static long getStringTimeDiff(String time1, String time2, SimpleDateFormat format) {
        long diff = 0L;
        try {
            Date startTime = format.parse(time1);
            Date endTime = format.parse(time2);
            diff = endTime.getTime() - startTime.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8ba1\u7b97\u65f6\u95f4\u5dee\u51fa\u73b0\u5f02\u5e38");
        }
        return diff;
    }

    public static long getStringTimeDiff_new(String time1, String time2, SimpleDateFormat format) {
        long diff = 0L;
        try {
            Date startTime = format.parse(time1);
            Date endTime = format.parse(time2);
            diff = startTime.getTime() - endTime.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8ba1\u7b97\u65f6\u95f4\u5dee\u51fa\u73b0\u5f02\u5e38");
        }
        return diff;
    }

    public static long getStringTimeDiff(Date date1, Date date2) {
        long diff = 0L;
        try {
            diff = date2.getTime() - date1.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8ba1\u7b97\u65f6\u95f4\u5dee\u51fa\u73b0\u5f02\u5e38");
        }
        return diff;
    }

    public static int getWeekInt(String dateString) throws ParseException {
        SimpleDateFormat dateFormater = new SimpleDateFormat(DATE_FORMAT_NORMAL);
        Date dateObject = dateFormater.parse(dateString);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateObject);
        int dayOfWeek = calendar.get(7);
        return dayOfWeek;
    }

    public static String getWeekStr(String dateString) {
        String weekStr = "";
        try {
            int weekInt = DateUtil.getWeekInt(dateString);
            if (weekInt == 2) {
                weekStr = "\u5468\u4e00";
            }
            if (weekInt == 3) {
                weekStr = "\u5468\u4e8c";
            }
            if (weekInt == 4) {
                weekStr = "\u5468\u4e09";
            }
            if (weekInt == 5) {
                weekStr = "\u5468\u56db";
            }
            if (weekInt == 6) {
                weekStr = "\u5468\u4e94";
            }
            if (weekInt == 7) {
                weekStr = "\u5468\u516d";
            }
            if (weekInt == 1) {
                weekStr = "\u5468\u65e5";
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return weekStr;
    }

    public static List<String[]> getAllTheDateOftheMonth(Date date) throws ParseException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        String[] dateWeekArr = null;
        int month = cal.get(2);
        while (cal.get(2) == month) {
            dateWeekArr = new String[]{DateUtil.getDateNormalString(cal.getTime()), String.valueOf(DateUtil.getWeekInt(DateUtil.getDateNormalString(cal.getTime())))};
            list.add(dateWeekArr);
            cal.add(5, 1);
        }
        return list;
    }

    public static String getAfertDate(String nowdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(YEAR_MONTH_FORMAT);
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(nowdate));
        cal.add(2, 1);
        return sdf.format(cal.getTime());
    }

    public static String getBeforeDate(String nowdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(YEAR_MONTH_FORMAT);
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(nowdate));
        cal.add(2, -1);
        return sdf.format(cal.getTime());
    }

    public static int getMinites(String date1, String date2) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT_SHORT_M);
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(sdf.parse(date1));
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(sdf.parse(date2));
        int hour = cal1.get(11) - cal2.get(11);
        int minite = cal1.get(12) - cal2.get(12);
        return hour * 60 + minite;
    }

    public static int getWorkTimePeriod(String beginDate, String endDate) throws ParseException {
        List<String> dateList = DateUtil.getDateList(beginDate, endDate);
        int time = 0;
        int len = dateList.size();
        for (int i = 0; i < len; ++i) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(sdf.parse(dateList.get(i)));
            int week = cal.get(7) - 1;
            if (week == 6 || week == 0) continue;
            time += 8;
        }
        return time;
    }

    public static String getRightDateFormat(String strDate) throws ParseException {
        SimpleDateFormat t1 = new SimpleDateFormat(DATE_FORMAT_CHINA);
        SimpleDateFormat t2 = new SimpleDateFormat(TIME_FORMAT_NORMAL);
        String str = "";
        Date date = t1.parse(strDate);
        str = t2.format(date);
        return str;
    }

    public static boolean isRightDateStr(String dateStr, String datePattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        try {
            dateFormat.setLenient(false);
            dateFormat.parse(dateStr);
            Date date = dateFormat.parse(dateStr);
            String newDateStr = dateFormat.format(date);
            return dateStr.equals(newDateStr);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static Date getDateByStr(String dateStr, String format) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(dateStr);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("Date or Time String is invalid.");
        }
    }

    public static Long getStringTimeDiffAndNegativeLong(String begin, String end, String format) {
        long diff = 0L;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Long startDate = sdf.parse(begin).getTime();
            Long endDate = sdf.parse(end).getTime();
            if (startDate > endDate) {
                diff = startDate - endDate;
            }
            diff = endDate - startDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8ba1\u7b97\u65f6\u95f4\u5dee\u51fa\u73b0\u5f02\u5e38");
        }
        return diff;
    }

    public static String getStringTimeDiffStr(long diff) {
        String diffStr = "";
        try {
            long minute1;
            long between = diff / 1000L;
            long hour1 = between / 3600L;
            if (hour1 > 0L) {
                diffStr = diffStr + hour1 + "\u5c0f\u65f6";
            }
            if ((minute1 = between % 3600L / 60L) > 0L) {
                diffStr = diffStr + minute1 + "\u5206";
            }
        }
        catch (Exception var15) {
            var15.printStackTrace();
            logger.error("\u8ba1\u7b97\u65f6\u95f4\u5dee\u51fa\u73b0\u5f02\u5e38");
        }
        return diffStr;
    }

    public static String getStringTimeDiffStrByHour(long diff) {
        String diffStr = "";
        try {
            float minute1;
            long between = diff / 1000L;
            long hour1 = between / 3600L;
            if (hour1 > 0L) {
                diffStr = diffStr + hour1 + "\u5c0f\u65f6";
            }
            if ((minute1 = BigDecimal.valueOf(between % 3600L / 60L).divide(BigDecimal.valueOf(60L), 2, 4).floatValue()) > 0.0f) {
                diffStr = (float)hour1 + minute1 + "\u5c0f\u65f6";
            }
        }
        catch (Exception var15) {
            var15.printStackTrace();
            logger.error("\u8ba1\u7b97\u65f6\u95f4\u5dee\u51fa\u73b0\u5f02\u5e38");
        }
        return diffStr;
    }

    public static void main(String[] args) {
        Integer i = 1;
        System.out.println("args = " + (1.0f + BigDecimal.valueOf(0L).divide(BigDecimal.valueOf(7L), 2, 4).floatValue()));
    }
}

