/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.utils;

import com.xforceplus.vanke.sc.outer.api.imsCore.util.CommonTools;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.PropertieUtil;
import com.xforceplus.xplat.aws.common.AwsHelper;
import com.xforceplus.xplat.aws.sqs.SqsService;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import net.wicp.tams.common.Result;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

@Component(value="queueSender")
public class QueueSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueSender.class);
    @Autowired
    private JmsTemplate jmsTemplate;
    @Autowired
    private SqsService sqsService;

    public int sendSqsMessage(String queueName, String message, Map<String, String> porperties) {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 30);
        porperties.put("password", PropertieUtil.password);
        if (!StringUtils.isNotBlank((CharSequence)porperties.get("requestType"))) {
            porperties.put("requestType", "0");
        }
        if (!StringUtils.isNotBlank((CharSequence)porperties.get("groupFlag"))) {
            porperties.put("groupFlag", "SC@vanke");
        }
        if (!StringUtils.isNotBlank((CharSequence)porperties.get("systemOrig"))) {
            porperties.put("systemOrig", "SCFP");
        }
        if (!StringUtils.isNotBlank((CharSequence)porperties.get("requestSerialNo"))) {
            porperties.put("requestSerialNo", uuid);
        }
        if (!StringUtils.isNotBlank((CharSequence)porperties.get("applySerialNo"))) {
            porperties.put("applySerialNo", uuid);
        }
        porperties.put("username", PropertieUtil.userName);
        if (CommonTools.isEmpty(queueName)) {
            return -1;
        }
        if (CommonTools.isEmpty(message)) {
            return -1;
        }
        Result result = this.sqsService.sendStrMsg(AwsHelper.buildQueueName((String)queueName), message, porperties);
        LOGGER.info("************\u53d1\u9001\u6d88\u606f\u81f3SQS \u961f\u5217\u540d\u79f0 {} \u6d88\u606f\u5185\u5bb9 {}  \u961f\u5217\u5c5e\u6027 {}  \u53d1\u9001\u72b6\u6001 {}  \u53d1\u9001\u72b6\u6001\u4fe1\u606f {} ", new Object[]{queueName, message, porperties, result.isSuc() ? 1 : -1, result.getMessage()});
        return result.isSuc() ? 1 : -1;
    }

    public void send(String queueName, String message, Map<String, String> propertys) {
        this.sendNoLog(queueName, message, propertys);
    }

    public void sendNoLog(String queueName, final String message, final Map<String, String> propertys) {
        LOGGER.info("\u5411queue\u961f\u5217:[{}]\u5f00\u59cb\u53d1\u9001\u6d88\u606f[{}]......", new Object[]{queueName, message});
        try {
            this.jmsTemplate.send(queueName, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    TextMessage textMessage = session.createTextMessage(message);
                    if (null != propertys && !propertys.isEmpty()) {
                        for (Map.Entry entry : propertys.entrySet()) {
                            textMessage.setStringProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    return textMessage;
                }
            });
        }
        catch (JmsException jmsException) {
            // empty catch block
        }
        LOGGER.info("\u5411queue\u961f\u5217:[{}]\u53d1\u9001\u6d88\u606f[{}]\u5df2\u5b8c\u6210", new Object[]{queueName, message});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int textSend(String queueName, String messageContent, Map<String, String> property) {
        int res = 1;
        Connection connection = null;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(PropertieUtil.mqUsername, PropertieUtil.mqPasswod, PropertieUtil.mqUrl);
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(Boolean.TRUE.booleanValue(), 1);
            Queue destination = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(1);
            TextMessage message = session.createTextMessage(messageContent);
            if (property != null) {
                for (String key : property.keySet()) {
                    message.setStringProperty(key, property.get(key));
                }
            }
            producer.send((Message)message);
            session.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            res = 0;
        }
        finally {
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return res;
    }
}

