/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.base.enums.orders;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.CommonTools;
import java.util.stream.Stream;

public enum OrdersErrorEnum {
    ORDERS_LEGAL_SYNERGETICS_MISSING("ordersLegalSynergeticsMissing", "\u4e1a\u52a1\u5355\u5bf9\u5e94\u7684\u8d2d\u65b9\u6cd5\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728"),
    INVOICE_LEGAL_SYNERGETICS_MISSING("invoiceLegalSynergeticsMissing", "\u4e1a\u52a1\u5355\u4e0b\u53d1\u7968\u5bf9\u5e94\u7684\u8d2d\u65b9\u6cd5\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728,\u95ee\u9898\u53d1\u7968\u53f7\u7801\u96c6\u5408\uff1a%s"),
    LEGAL_SYNERGETICS_MISMATCHING("legalSynergeticsMismatching", "\u6cd5\u4eba\u4e3b\u6570\u636e\u4e0d\u5339\u914d"),
    AUTH_FLAG_MISSING("authFlagMissing", "\u662f\u5426\u62b5\u6263\u6807\u8bc6\u4e0d\u5b58\u5728"),
    AMOUNT_ERROR("amountError", "\u4e1a\u52a1\u5355\u4e0b\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0e\u7a0e\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u542b\u7a0e\u91d1\u989d,\u95ee\u9898\u53d1\u7968\u53f7\u7801\u96c6\u5408\uff1a%s"),
    BUSINESS_DEFERRED("businessDeferred", "\u4e1a\u52a1\u64cd\u4f5c\u8d85\u671f"),
    AUDIT_INVOICE_IMAGE_IS_DELETE("auditInvoiceImageIsDelete", "\u5df2\u5ba1\u6838\u5355\u636e\u53d1\u7968\u5f71\u50cf\u88ab\u5220\u9664,\u95ee\u9898\u53d1\u7968\u53f7\u7801\u96c6\u5408\uff1a%s"),
    SAP_AUTH_SEND_ERROR("sapAuthSendError", "\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4e0b\u53d1SAP"),
    INVOICE_AUTH_BY_LINE("invoiceAuthByLine", "\u4e1a\u52a1\u5355\u4e0b\u53d1\u7968\u88ab\u4e00\u7ebf\u52fe\u9009\u6216\u8ba4\u8bc1,\u95ee\u9898\u53d1\u7968\u53f7\u7801\u96c6\u5408\uff1a%s"),
    INVOICE_RED_DASHED_BY_SELLER("invoiceRedDashedBySeller", "\u4e1a\u52a1\u5355\u4e0b\u53d1\u7968\u88ab\u9500\u65b9\u7ea2\u51b2,\u95ee\u9898\u53d1\u7968\u53f7\u7801\u96c6\u5408\uff1a%s");

    private String code;
    private String name;

    private OrdersErrorEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static OrdersErrorEnum fromCode(String code) {
        return Stream.of(OrdersErrorEnum.values()).filter(t -> t.code.equals(code)).findFirst().orElse(null);
    }

    public static String getErrorInfo(String error, OrdersErrorEnum ordersErrorEnum, boolean flag, String invoices) {
        JSONObject errorInfo = new JSONObject();
        String value = ordersErrorEnum.getName();
        if (!CommonTools.isEmpty(error)) {
            errorInfo = JSONObject.parseObject((String)error);
        }
        if (!CommonTools.isEmpty(invoices) && (OrdersErrorEnum.INVOICE_LEGAL_SYNERGETICS_MISSING.code.equalsIgnoreCase(ordersErrorEnum.getCode()) || OrdersErrorEnum.AMOUNT_ERROR.code.equalsIgnoreCase(ordersErrorEnum.getCode()) || OrdersErrorEnum.AUDIT_INVOICE_IMAGE_IS_DELETE.code.equalsIgnoreCase(ordersErrorEnum.getCode()) || OrdersErrorEnum.INVOICE_AUTH_BY_LINE.code.equalsIgnoreCase(ordersErrorEnum.getCode()) || OrdersErrorEnum.INVOICE_RED_DASHED_BY_SELLER.code.equalsIgnoreCase(ordersErrorEnum.getCode()))) {
            value = String.format(ordersErrorEnum.name, invoices);
        }
        if (flag) {
            errorInfo.put(ordersErrorEnum.getCode(), (Object)value);
        } else {
            errorInfo.remove((Object)ordersErrorEnum.getCode());
        }
        if (!errorInfo.isEmpty()) {
            return errorInfo.toJSONString();
        }
        return "";
    }

    public static String getErrorInfo(String error, OrdersErrorEnum ordersErrorEnum, boolean flag) {
        return OrdersErrorEnum.getErrorInfo(error, ordersErrorEnum, flag, "");
    }
}

