/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.outer.api.imsCore.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public final class ValidatorUtil {
    public static final String[] IMG_FILE_TYPE = new String[]{".png", ".jpg", ".gif", ".jpeg"};

    private ValidatorUtil() {
    }

    public static boolean validateFileIsImage(String fileName, InputStream inputStream) throws IOException {
        boolean status = false;
        for (String string : IMG_FILE_TYPE) {
            if (!fileName.endsWith(string)) continue;
            status = true;
            break;
        }
        if (!status) {
            return status;
        }
        status = false;
        BufferedImage bufreader = ImageIO.read(inputStream);
        if (null == bufreader) {
            return status;
        }
        int width = bufreader.getWidth();
        int height = bufreader.getHeight();
        if (width == 0 || height == 0) {
            return status;
        }
        status = true;
        return status;
    }

    public static boolean validateXss(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("</script>", 2);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("<script(.*?)>", 42);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("e\u00adxpression\\((.*?)\\)", 42);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("javascript:", 2);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("vbscript:", 2);
        if (scriptPattern.matcher(value).find()) {
            return false;
        }
        scriptPattern = Pattern.compile("onload(.*?)=", 42);
        return !scriptPattern.matcher(value).find();
    }

    public static boolean validateLong(String value) {
        String regex = "0|([1-9]{1}[0-9]{0,19})";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validateLongs(String value) {
        String regex = "(\\,(0|([1-9]{1}[0-9]{0,19})))+";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validateInteger(String value) {
        String regex = "0|([1-9]{1}[0-9]{0,10})";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validateIp(String value) {
        String regex = "\\d{1,3}(\\.\\d{1,3}){3}";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validateUserName(String value) {
        String regex = "(?!_)\\w{6,32}";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validatePassword(String value) {
        String regex = "(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,32}";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validateMobile(String value) {
        String regex = "1\\d{10}";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validateLinkNo(String value) {
        String regex = "(1\\d{10})|((\\d{3,4}\\-)?\\d{7,8})";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validateTime(String value) {
        String regex = "([1-2]{1}[0-9]{3})((1[0-2]{1})|(0[1-9]{1}))((0[1-9]{1})|([1-2]{1}[0-9]{1})|(3[0-1]{1}))";
        boolean result = Pattern.matches(regex, value);
        return result;
    }

    public static boolean validateCode(String value) {
        String regex = "\\w{1,32}";
        boolean result = Pattern.matches(regex, value);
        return result;
    }
}

