/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xforceplus.vanke.sc.base.mqqueue.JcQueue;
import com.xforceplus.vanke.sc.model.LogApiModel;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.baseinfo.ApiRequest;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.baseinfo.Response;
import com.xforceplus.vanke.sc.utils.QueueSender;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemApiDataSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemApiDataSender.class);
    @Autowired
    private QueueSender queueSender;

    public void fpApiDataDownload(String number, String provider, String caller, String apiUrl, String methodName, String params, String result, int issucess, String desc, Date date) {
        LogApiModel sysApiLogEntity = new LogApiModel();
        sysApiLogEntity.setNumber(number);
        sysApiLogEntity.setProvider(provider);
        sysApiLogEntity.setCaller(caller);
        sysApiLogEntity.setApiUrl(apiUrl);
        sysApiLogEntity.setMethodName(methodName);
        sysApiLogEntity.setParams(params);
        sysApiLogEntity.setResult(result);
        sysApiLogEntity.setIssucess(issucess);
        sysApiLogEntity.setApiDesc(desc);
        sysApiLogEntity.setReceiveTime(date);
        sysApiLogEntity.setFinishTime(new Date());
        sysApiLogEntity.setCreateDate(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String str = JSON.toJSONString((Object)sysApiLogEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        QueueSender.textSend("fpApiDataDownload", str, null);
    }

    public void fpApiDataResponse(ApiRequest apiRequest, JcQueue jcQueue, Response response) {
        LogApiModel sysApiLogEntity = new LogApiModel();
        if (StringUtils.isBlank((CharSequence)apiRequest.getNumber())) {
            apiRequest.setNumber(MDC.get((String)"TRACE_ID"));
        }
        sysApiLogEntity.setNumber(apiRequest.getNumber());
        sysApiLogEntity.setProvider(apiRequest.getProvider());
        sysApiLogEntity.setCaller(apiRequest.getCaller());
        sysApiLogEntity.setApiUrl(jcQueue.getUrl());
        sysApiLogEntity.setMethodName(jcQueue.getApiQueue().getName());
        sysApiLogEntity.setParams(JSON.toJSONString((Object)apiRequest.getParams()));
        sysApiLogEntity.setResult(JSON.toJSONString((Object)response));
        sysApiLogEntity.setIssucess(Response.OK.equals(response.getCode()) ? 200 : 500);
        sysApiLogEntity.setApiDesc(jcQueue.getApiQueue().getMsg());
        sysApiLogEntity.setReceiveTime(new Date());
        sysApiLogEntity.setFinishTime(new Date());
        sysApiLogEntity.setCreateDate(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String str = JSON.toJSONString((Object)sysApiLogEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        QueueSender.textSend("fpApiDataDownload", str, null);
    }
}

