/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.config;

import com.alibaba.fastjson.JSONException;
import com.xforceplus.xplatalarm.service.XplatExceptionAlarmService;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.api.TokenExpiredException;
import com.xforceplus.xplatsecurity.api.TokenValidateException;
import java.util.Optional;
import javax.validation.ValidationException;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@ControllerAdvice
public class ExceptionAdvice {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);
    @Autowired(required=false)
    private Optional<XplatExceptionAlarmService> alarmService;

    @ExceptionHandler(value={JSONException.class})
    public ResponseEntity<Response> handleJSONException(JSONException ex) {
        logger.error("\u4f20\u53c2\u5f02\u5e38", (Throwable)ex);
        return ResponseEntity.ok((Object)Response.failed((String)ex.getMessage()));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<Response> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException ex) {
        logger.error("\u65b9\u6cd5\u7c7b\u578b\u8c03\u7528\u9519\u8bef", (Throwable)ex);
        return ResponseEntity.ok((Object)Response.failed((String)ex.getMessage()));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<Response> handleHttpMessageNotReadableException(HttpMessageNotReadableException ex) {
        logger.error("\u4f20\u53c2\u683c\u5f0f\u5f02\u5e38", (Throwable)ex);
        return ResponseEntity.ok((Object)Response.failed((String)"\u4f20\u53c2\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01"));
    }

    @ExceptionHandler(value={TokenValidateException.class, TokenExpiredException.class})
    public ResponseEntity<Response> handleTokenException(Exception e) {
        logger.error(e.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)Response.failed((String)e.getMessage()));
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<Response> handleTokenException(ValidationException ex) {
        logger.error("\u8bf7\u6c42\u9a8c\u8bc1\u5931\u8d25\uff1a" + ex.getMessage());
        return ResponseEntity.ok((Object)Response.failed((String)ex.getMessage()));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<Response> handleRuntimeException(RuntimeException ex) {
        Throwable e = ex.getCause();
        if (e == null) {
            return this.handleException((Exception)ex);
        }
        return this.handleException((Exception)e);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Response> handleException(Exception ex) {
        if (ex.getClass().getPackage().getName().startsWith("com.xforceplus")) {
            return ResponseEntity.ok((Object)Response.failed((String)ex.getMessage()));
        }
        logger.error("\u670d\u52a1\u5185\u90e8\u5f02\u5e38\uff01", (Throwable)ex);
        this.alarmService.ifPresent(service -> service.createHttpNotice(TraceContext.traceId(), (Throwable)ex, "", null, null));
        return ResponseEntity.ok((Object)Response.failed((String)"\u7cfb\u7edf\u6545\u969c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
    }
}

