/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.config;

import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class FeignBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.containsBeanDefinition(beanFactory, new String[]{"feignContext", "eurekaAutoServiceRegistration"})) {
            BeanDefinition bd = beanFactory.getBeanDefinition("feignContext");
            bd.setDependsOn(new String[]{"eurekaAutoServiceRegistration"});
        }
    }

    private boolean containsBeanDefinition(ConfigurableListableBeanFactory beanFactory, String ... beans) {
        return Arrays.stream(beans).allMatch(b -> beanFactory.containsBeanDefinition(b));
    }
}

