/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.common.process;

import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.base.enums.common.UploadTypeEnum;
import com.xforceplus.vanke.sc.service.FileBusiness;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadFilesProcess {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FileBusiness fileBusiness;

    public CommonResponse<List<String>> execute(List<MultipartFile> files, UploadTypeEnum uploadType) {
        this.check(files, uploadType);
        return this.process(files, uploadType);
    }

    private void check(List<MultipartFile> files, UploadTypeEnum uploadType) throws ValidationException {
        if (CollectionUtils.isEmpty(files) || files.stream().allMatch(file -> file.isEmpty())) {
            throw new ValidationException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (uploadType == null) {
            throw new ValidationException("\u4e0a\u4f20\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        files.stream().filter(file -> !file.isEmpty()).forEach(file -> {
            String name = file.getOriginalFilename();
            if (!name.contains(".")) {
                throw new ValidationException("\u672a\u77e5\u6587\u4ef6\u7c7b\u578b");
            }
            String ext = name.substring(name.lastIndexOf("."));
            if (!uploadType.validate(ext)) {
                throw new ValidationException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d");
            }
        });
    }

    private CommonResponse<List<String>> process(List<MultipartFile> files, UploadTypeEnum uploadType) throws RuntimeException {
        return CommonResponse.ok((String)"\u6210\u529f", files.stream().map(file -> {
            if (file.isEmpty()) {
                return null;
            }
            String oldName = file.getOriginalFilename();
            String newName = UUID.randomUUID() + oldName.substring(oldName.lastIndexOf("."));
            try {
                return this.fileBusiness.uploadFile(newName, file.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("\u4e0a\u4f20\u6587\u4ef6\u3010%s\u3011\u5931\u8d25", oldName), e);
            }
        }).collect(Collectors.toList()));
    }
}

