/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.config.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.base.enums.PerpetualCalendarEnum;
import com.xforceplus.vanke.sc.client.model.PerpetualCalendar;
import com.xforceplus.vanke.sc.repository.dao.WkPerpetualCalendarDao;
import com.xforceplus.vanke.sc.repository.model.WkPerpetualCalendarEntity;
import com.xforceplus.vanke.sc.repository.model.WkPerpetualCalendarExample;
import com.xforceplus.vanke.sc.service.PerpetualCalendarBusiness;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SavePerpetualCalendarProcess
extends AbstractProcess<PerpetualCalendar, Long> {
    @Autowired
    private WkPerpetualCalendarDao wkPerpetualCalendarDao;
    @Autowired
    private PerpetualCalendarBusiness perpetualCalendarBusiness;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RuntimeException.class})
    protected CommonResponse<Long> process(PerpetualCalendar request) throws RuntimeException {
        try {
            if (StringUtils.isNotEmpty((String)request.getYear())) {
                WkPerpetualCalendarExample example = new WkPerpetualCalendarExample();
                example.createCriteria().andYearEqualTo(request.getYear());
                long count = this.wkPerpetualCalendarDao.countByExample(example);
                if (count > 0L) {
                    return CommonResponse.failed((String)"\u5df2\u5b58\u5728\u8be5\u5e74\u4efd\u7684\u65e5\u5386\uff0c\u8bf7\u52ff\u91cd\u590d\u521b\u5efa\uff01");
                }
                Calendar c = Calendar.getInstance();
                int year = Integer.parseInt(request.getYear());
                this.save(request, PerpetualCalendarEnum.YEAR.getCode().intValue(), request.getYear(), "", "", 0);
                c.set(1, year);
                for (int i = 0; i < 12; ++i) {
                    this.save(request, PerpetualCalendarEnum.MONTH.getCode().intValue(), request.getYear(), i + 1 + "", "", 0);
                    c.set(2, i);
                    c.set(5, 1);
                    this.printMonth(c, request);
                }
            } else {
                return CommonResponse.failed((String)"\u8bf7\u8f93\u5165\u9700\u8981\u521b\u5efa\u7684\u5e74\u4efd");
            }
            return CommonResponse.ok((String)"\u521b\u5efa\u6210\u529f");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printMonth(Calendar c, PerpetualCalendar request) {
        c.set(5, 1);
        int month = c.get(2);
        while (c.get(2) == month) {
            this.save(request, PerpetualCalendarEnum.DAY.getCode().intValue(), request.getYear(), month + 1 + "", c.get(5) + "", c.get(7) == 1 ? 7 : c.get(7) - 1);
            c.add(5, 1);
        }
    }

    public void save(PerpetualCalendar request, int type, String year, String month, String day, int weekday) {
        WkPerpetualCalendarEntity entity = new WkPerpetualCalendarEntity();
        Long uningHour = 28800000L;
        if (type == PerpetualCalendarEnum.YEAR.getCode()) {
            entity.setYear(year);
        } else if (type == PerpetualCalendarEnum.MONTH.getCode()) {
            entity.setYear(year);
            entity.setMonth(month);
            entity.setAmBegin("08:00");
            entity.setAmEnd("12:00");
            entity.setPmBegin("13:00");
            entity.setPmEnd("17:00");
        } else if (type == PerpetualCalendarEnum.DAY.getCode()) {
            entity.setYear(year);
            entity.setMonth(month);
            entity.setDay(day);
            entity.setYearMonthDay(year + String.format("%02d", Integer.parseInt(month)) + String.format("%02d", Integer.parseInt(day)));
            entity.setWeekday(Integer.valueOf(weekday));
            if (Arrays.asList(6, 7).contains(weekday)) {
                entity.setIsWorkday(Integer.valueOf(0));
            } else {
                entity.setAmBegin("08:00");
                entity.setAmEnd("12:00");
                entity.setPmBegin("13:00");
                entity.setPmEnd("17:00");
                entity.setRuningHour(uningHour);
                entity.setIsWorkday(Integer.valueOf(1));
            }
        }
        entity.setIsSpecial(Integer.valueOf(0));
        entity.setType(Integer.valueOf(type));
        entity.setCreateUserId(request.getCreateUserId());
        entity.setCreateUserName(request.getCreateUserName());
        entity.setCreateTime(new Date(request.getCreateTime()));
        this.perpetualCalendarBusiness.insert(entity);
    }
}

