/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.config.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.base.enums.PerpetualCalendarEnum;
import com.xforceplus.vanke.sc.client.model.PerpetualCalendarConfigList;
import com.xforceplus.vanke.sc.client.model.WkPerpetualCalendarConofigDTO;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.DateUtil;
import com.xforceplus.vanke.sc.repository.model.WkPerpetualCalendarEntity;
import com.xforceplus.vanke.sc.repository.model.WkPerpetualCalendarExample;
import com.xforceplus.vanke.sc.service.PerpetualCalendarBusiness;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdatePerpetualCalendarConfigProcess
extends AbstractProcess<PerpetualCalendarConfigList, Long> {
    @Autowired
    private PerpetualCalendarBusiness perpetualCalendarBusiness;

    protected CommonResponse<Long> process(PerpetualCalendarConfigList request) throws RuntimeException {
        try {
            List entities = request.getEntities();
            if (entities.size() == 0) {
                return CommonResponse.failed((String)"\u65e0\u53ef\u7528\u6570\u636e\uff01");
            }
            for (WkPerpetualCalendarConofigDTO entity : entities) {
                Long runingHour = DateUtil.getStringTimeDiffAndNegativeLong((String)entity.getAmBegin(), (String)entity.getAmEnd(), (String)"HH:mm") + DateUtil.getStringTimeDiffAndNegativeLong((String)entity.getPmBegin(), (String)entity.getPmEnd(), (String)"HH:mm");
                WkPerpetualCalendarEntity wkPerpetualCalendarEntity = new WkPerpetualCalendarEntity();
                wkPerpetualCalendarEntity.setAmBegin(entity.getAmBegin());
                wkPerpetualCalendarEntity.setAmEnd(entity.getAmEnd());
                wkPerpetualCalendarEntity.setPmBegin(entity.getPmBegin());
                wkPerpetualCalendarEntity.setPmEnd(entity.getPmEnd());
                wkPerpetualCalendarEntity.setIsSpecial(Integer.valueOf(0));
                wkPerpetualCalendarEntity.setRuningHour(runingHour);
                WkPerpetualCalendarExample example = new WkPerpetualCalendarExample();
                example.createCriteria().andYearEqualTo(entity.getYear()).andMonthIn(entity.getMonths()).andIsWorkdayEqualTo(Integer.valueOf(1));
                example.or(new WkPerpetualCalendarExample().createCriteria().andYearEqualTo(entity.getYear()).andMonthIn(entity.getMonths()).andTypeEqualTo(PerpetualCalendarEnum.MONTH.getCode()));
                this.perpetualCalendarBusiness.update(wkPerpetualCalendarEntity, example);
            }
        }
        catch (Exception e) {
            return CommonResponse.failed((String)e.toString());
        }
        return CommonResponse.ok((String)"\u6210\u529f\uff01");
    }
}

