/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.config.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.base.enums.PerpetualCalendarEnum;
import com.xforceplus.vanke.sc.client.model.PerpetualCalendar;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.DateUtil;
import com.xforceplus.vanke.sc.repository.dao.WkPerpetualCalendarDao;
import com.xforceplus.vanke.sc.repository.model.WkPerpetualCalendarEntity;
import com.xforceplus.vanke.sc.repository.model.WkPerpetualCalendarExample;
import com.xforceplus.vanke.sc.service.PerpetualCalendarBusiness;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdatePerpetualCalendarProcess
extends AbstractProcess<PerpetualCalendar, Integer> {
    @Autowired
    private WkPerpetualCalendarDao wkPerpetualCalendarDao;
    @Autowired
    private PerpetualCalendarBusiness perpetualCalendarBusiness;

    protected CommonResponse<Integer> process(PerpetualCalendar request) throws RuntimeException {
        try {
            if (request.getIsWorkday() == null) {
                return CommonResponse.failed((String)"\u662f\u5426\u4e3a\u5de5\u4f5c\u65e5\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            WkPerpetualCalendarExample example = new WkPerpetualCalendarExample();
            example.createCriteria().andMonthEqualTo(request.getMonth()).andTypeEqualTo(PerpetualCalendarEnum.MONTH.getCode());
            List wkPerpetualCalendarEntities = this.wkPerpetualCalendarDao.selectByExample(example);
            if (wkPerpetualCalendarEntities.size() == 0) {
                return CommonResponse.failed((String)"\u672a\u67e5\u5230\u5f53\u6708\u6708\u4efd\u6570\u636e\uff01");
            }
            WkPerpetualCalendarEntity monthEntity = (WkPerpetualCalendarEntity)wkPerpetualCalendarEntities.get(0);
            WkPerpetualCalendarEntity entity = new WkPerpetualCalendarEntity();
            entity.setIsWorkday(request.getIsWorkday());
            entity.setId(request.getId());
            entity.setAmBegin(request.getAmBegin());
            entity.setAmEnd(request.getAmEnd());
            entity.setPmBegin(request.getPmBegin());
            entity.setPmEnd(request.getPmEnd());
            if (request.getIsWorkday() == 1) {
                Long runingHour = 0L;
                if (StringUtils.isNotBlank((String)entity.getAmBegin()) && StringUtils.isNotBlank((String)entity.getAmEnd())) {
                    runingHour = runingHour + DateUtil.getStringTimeDiffAndNegativeLong((String)entity.getAmBegin(), (String)entity.getAmEnd(), (String)"HH:mm");
                }
                if (StringUtils.isNotBlank((String)entity.getPmBegin()) && StringUtils.isNotBlank((String)entity.getPmEnd())) {
                    runingHour = runingHour + DateUtil.getStringTimeDiffAndNegativeLong((String)entity.getPmBegin(), (String)entity.getPmEnd(), (String)"HH:mm");
                }
                entity.setRuningHour(runingHour);
            }
            if (!(request.getIsWorkday() != 1 || monthEntity.getAmBegin().equals(request.getAmBegin()) && monthEntity.getAmEnd().equals(request.getAmEnd()) && monthEntity.getPmBegin().equals(request.getPmBegin()) && monthEntity.getPmEnd().equals(request.getPmEnd()))) {
                entity.setIsSpecial(Integer.valueOf(1));
            } else {
                entity.setIsSpecial(Integer.valueOf(0));
            }
            int i = this.perpetualCalendarBusiness.update(entity);
            return CommonResponse.ok((String)"\u6210\u529f\uff01", (Object)i);
        }
        catch (Exception e) {
            return CommonResponse.failed((String)e.toString());
        }
    }
}

