/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.legalperson.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.sc.client.model.GetCheckConfirmListRequest;
import com.xforceplus.vanke.sc.repository.daoext.WkLegalPersonDaoExt;
import com.xforceplus.vanke.sc.repository.model.CheckConfirmListModel;
import com.xforceplus.vanke.sc.repository.model.CheckCountModel;
import com.xforceplus.vanke.sc.repository.model.InvoiceCheckCountModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetCheckConfirmListProcess
extends AbstractProcess<GetCheckConfirmListRequest, ListResult<CheckConfirmListModel>> {
    @Autowired
    private WkLegalPersonDaoExt wkLegalPersonDaoExt;

    protected void check(GetCheckConfirmListRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<CheckConfirmListModel>> process(GetCheckConfirmListRequest request) throws RuntimeException {
        List checkConfirmList;
        if (null != request.getPageNo() && null != request.getPageSize()) {
            request.setPageNo(Integer.valueOf((request.getPageNo() - 1) * request.getPageSize()));
        }
        if (ValidatorUtil.isEmpty((Collection)(checkConfirmList = this.wkLegalPersonDaoExt.getCheckConfirmList(request)))) {
            ListResult result = new ListResult(this.wkLegalPersonDaoExt.countCheckConfirmList(request), checkConfirmList);
            return CommonResponse.ok((String)"", (Object)result);
        }
        List relTaxList = checkConfirmList.stream().map(CheckConfirmListModel::getRelTax).collect(Collectors.toList());
        Map checkConfirmListModelMap = checkConfirmList.stream().collect(Collectors.toMap(CheckConfirmListModel::getRelTax, Function.identity()));
        List checkConfirmModelList = this.wkLegalPersonDaoExt.checkConfirmCount(relTaxList);
        if (ValidatorUtil.isNotEmpty((Collection)checkConfirmModelList) && ((CheckCountModel)checkConfirmModelList.get(0)).getConfirmCount() > 0L) {
            checkConfirmModelList.stream().forEach(checkCountModel -> {
                if (checkConfirmListModelMap.containsKey(checkCountModel.getPurchaserTaxNo())) {
                    ((CheckConfirmListModel)checkConfirmListModelMap.get(checkCountModel.getPurchaserTaxNo())).setIsAuthing(1);
                }
            });
        }
        List invoiceCheckCountModelList = this.wkLegalPersonDaoExt.getInvoiceCount(relTaxList);
        Map invoiceCheckCountModelMap = invoiceCheckCountModelList.stream().collect(Collectors.toMap(InvoiceCheckCountModel::getPurchaserTaxNo, Function.identity()));
        checkConfirmList.stream().forEach(checkConfirmListModel -> {
            if (invoiceCheckCountModelMap.containsKey(checkConfirmListModel.getRelTax())) {
                InvoiceCheckCountModel invoiceCheckCountModel = (InvoiceCheckCountModel)invoiceCheckCountModelMap.get(checkConfirmListModel.getRelTax());
                checkConfirmListModel.setInvoiceCount(invoiceCheckCountModel.getInvoiceCount());
                checkConfirmListModel.setAuthValidTaxAmount(invoiceCheckCountModel.getAuthValidTaxAmount());
                checkConfirmListModel.setAmountWithTax(invoiceCheckCountModel.getAmountWithTax());
            }
        });
        ListResult result = new ListResult(this.wkLegalPersonDaoExt.countCheckConfirmList(request), checkConfirmList);
        return CommonResponse.ok((String)"", (Object)result);
    }
}

