/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.logapi.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.sc.client.model.GetLogApiListRequest;
import com.xforceplus.vanke.sc.client.model.LogApiDTO;
import com.xforceplus.vanke.sc.repository.dao.LogApiErrorDao;
import com.xforceplus.vanke.sc.repository.model.LogApiErrorExample;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GetLogApiErrorListProcess
extends AbstractProcess<GetLogApiListRequest, ListResult<LogApiDTO>> {
    @Autowired
    private LogApiErrorDao logApiErrorDao;

    protected CommonResponse<ListResult<LogApiDTO>> process(GetLogApiListRequest request) throws RuntimeException {
        LogApiErrorExample logApiErrorExample = new LogApiErrorExample();
        logApiErrorExample.setOrderByClause("api_log_id DESC");
        logApiErrorExample.setLimit(request.getRows());
        logApiErrorExample.setOffset(request.getOffset());
        LogApiErrorExample.Criteria criteria = logApiErrorExample.createCriteria();
        if (!StringHelp.safeIsEmpty((Object)request.getCaller())) {
            criteria.andCallerEqualTo(request.getCaller());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getProvider())) {
            criteria.andProviderEqualTo(request.getProvider());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getNumber())) {
            criteria.andNumberEqualTo(request.getNumber());
        }
        if (null != request.getIssucess()) {
            if (200 == request.getIssucess()) {
                criteria.andIssucessEqualTo(request.getIssucess());
            } else {
                criteria.andIssucessNotEqualTo(Integer.valueOf(200));
            }
        }
        if (!StringUtils.isEmpty((Object)request.getMethodName())) {
            criteria.andMethodNameEqualTo(request.getMethodName());
        }
        if (!CollectionUtils.isEmpty((Collection)request.getReceiveTime()) && request.getReceiveTime().size() == 2) {
            criteria.andReceiveTimeBetween(new Date((Long)request.getReceiveTime().get(0)), new Date((Long)request.getReceiveTime().get(1)));
        }
        ListResult listResult = new ListResult(Long.valueOf(this.logApiErrorDao.countByExample(logApiErrorExample)), this.logApiErrorDao.selectByExampleWithBLOBs(logApiErrorExample));
        ListResult result = (ListResult)JSON.parseObject((String)JSON.toJSONString((Object)listResult), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
    }
}

