/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.logmaininfo.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.sc.client.model.GetLogMainInfoListRequest;
import com.xforceplus.vanke.sc.client.model.LogMaininfoDTO;
import com.xforceplus.vanke.sc.repository.dao.LogMaininfoDao;
import com.xforceplus.vanke.sc.repository.model.LogMaininfoExample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogMainInfoListProcess
extends AbstractProcess<GetLogMainInfoListRequest, ListResult<LogMaininfoDTO>> {
    @Autowired
    private LogMaininfoDao logMaininfoDao;

    protected CommonResponse<ListResult<LogMaininfoDTO>> process(GetLogMainInfoListRequest request) throws RuntimeException {
        LogMaininfoExample logMaininfoExample = new LogMaininfoExample();
        logMaininfoExample.setLimit(request.getRows());
        logMaininfoExample.setOffset(request.getOffset());
        LogMaininfoExample.Criteria criteria = logMaininfoExample.createCriteria();
        logMaininfoExample.setOrderByClause("operation_time desc");
        if (ValidatorUtil.isNotEmpty((String)request.getNumber())) {
            criteria.andNumberEqualTo(request.getNumber());
        }
        if (ValidatorUtil.isNotEmpty((String)request.getTaxNo())) {
            criteria.andTaxNoEqualTo(request.getTaxNo());
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getOperationTime()) && request.getOperationTime().size() == 2) {
            criteria.andOperationTimeBetween(new Date((Long)request.getOperationTime().get(0)), new Date((Long)request.getOperationTime().get(1)));
        }
        List logMaininfoEntityList = this.logMaininfoDao.selectByExample(logMaininfoExample);
        ArrayList logMaininfoDTOList = Lists.newArrayList();
        logMaininfoEntityList.stream().forEach(logMaininfoEntity -> {
            LogMaininfoDTO logMaininfoDTO = new LogMaininfoDTO();
            BeanUtils.copyProperties((Object)logMaininfoEntity, (Object)logMaininfoDTO);
            logMaininfoDTOList.add(logMaininfoDTO);
        });
        ListResult listResult = new ListResult(Long.valueOf(this.logMaininfoDao.countByExample(logMaininfoExample)), (List)logMaininfoDTOList);
        return CommonResponse.ok((String)"", (Object)listResult);
    }
}

