/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.menu.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.sc.client.model.GetMenuListRequest;
import com.xforceplus.vanke.sc.client.model.MenuTreeBean;
import com.xforceplus.vanke.sc.repository.dao.SysMenuDao;
import com.xforceplus.vanke.sc.repository.daoext.SysRoleMenuDaoExt;
import com.xforceplus.vanke.sc.repository.model.SysMenuExample;
import com.xforceplus.vanke.sc.service.MenuBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetMenuListProcess
extends AbstractProcess<GetMenuListRequest, ListResult<MenuTreeBean>> {
    @Autowired
    private SysMenuDao sysMenuDao;
    @Autowired
    private SysRoleMenuDaoExt sysRoleMenuDaoExt;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private MenuBusiness menuBusiness;

    protected CommonResponse<ListResult<MenuTreeBean>> process(GetMenuListRequest request) throws RuntimeException {
        SysMenuExample menuExample = this.createExample(request);
        long total = this.sysMenuDao.countByExample(menuExample);
        List menuEntities = this.sysMenuDao.selectByExample(menuExample);
        List menuTreeBeanList = this.menuBusiness.setMenuTreeBean(menuEntities);
        ArrayList menuList = Lists.newArrayList();
        menuTreeBeanList.stream().forEach(item -> {
            if (item.getParentId() == 0L) {
                menuList.add(this.menuBusiness.findChildren(item, menuTreeBeanList));
            }
        });
        ListResult listResult = new ListResult(Long.valueOf(total), (List)menuList);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)listResult);
    }

    private SysMenuExample createExample(GetMenuListRequest request) {
        UserSessionInfo userInfo;
        SysMenuExample menuExample = new SysMenuExample();
        SysMenuExample.Criteria criteria = menuExample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)request.getMenuName())) {
            criteria.andMenuNameLike(String.format("%%%s%%", request.getMenuName()));
        }
        if (request.getStatus() != null) {
            criteria.andStatusEqualTo(request.getStatus());
        }
        if (!(userInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo()).getIsAdmin()) {
            List menuIds = this.sysRoleMenuDaoExt.selectMenuByUserId(Long.valueOf(userInfo.getAccountId()));
            criteria.andMenuIdIn(menuIds);
        }
        menuExample.setOrderByClause(" menu_order asc");
        return menuExample;
    }
}

