/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.menu.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.SaveMenuRequest;
import com.xforceplus.vanke.sc.client.model.SysMenuDTO;
import com.xforceplus.vanke.sc.service.MenuBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaveMenuProcess
extends AbstractProcess<SaveMenuRequest, List<Long>> {
    @Autowired
    private MenuBusiness menuBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(SaveMenuRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        if (!((UserContext)this.contextHolder.get()).getUserSessionInfo().getIsAdmin()) {
            throw new ValidationException("\u975e\u7ba1\u7406\u5458\u65e0\u6cd5\u65b0\u589e\u83dc\u5355");
        }
        if (CollectionUtils.isEmpty((Collection)request.getEntities())) {
            throw new ValidationException("\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SysMenuDTO entity : request.getEntities()) {
            this.checkEmpty(entity.getMenuName(), "\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getParentId(), "\u7236\u83dc\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getMenuModel(), "\u83dc\u5355\u6240\u5c5e\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected CommonResponse<List<Long>> process(SaveMenuRequest request) throws RuntimeException {
        List keys = request.getEntities().stream().map(entity -> {
            int result = this.menuBusiness.insert(entity);
            if (result > 0) {
                return entity.getMenuId();
            }
            return null;
        }).collect(Collectors.toList());
        if (keys.stream().anyMatch(key -> key != null)) {
            if (keys.stream().anyMatch(key -> key == null)) {
                return CommonResponse.ok((String)"\u90e8\u5206\u65b0\u589e\u6210\u529f", keys);
            }
            return CommonResponse.ok((String)"\u65b0\u589e\u6210\u529f", keys);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u65b0\u589e");
    }
}

