/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.menu.process;

import com.xforceplus.landedestate.basecommon.process.AbstractKeyProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.UpdateMenuRequest;
import com.xforceplus.vanke.sc.service.MenuBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateMenuProcess
extends AbstractKeyProcess<Long, UpdateMenuRequest, Boolean> {
    @Autowired
    private MenuBusiness menuBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(Long menuId, UpdateMenuRequest request) throws ValidationException {
        super.check((Object)menuId, (BaseRequest)request);
        if (!((UserContext)this.contextHolder.get()).getUserSessionInfo().getIsAdmin()) {
            throw new ValidationException("\u975e\u7ba1\u7406\u5458\u65e0\u6cd5\u66f4\u65b0\u83dc\u5355");
        }
        this.checkEmpty(request.getMenuName(), "\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getMenuPath(), "\u8df3\u8f6c\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getParentId(), "\u7236\u83dc\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getMenuOrder(), "\u83dc\u5355\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getMenuDesc(), "\u83dc\u5355\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getMenuModel(), "\u83dc\u5355\u6240\u5c5e\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getStatus(), "\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Boolean> process(Long menuId, UpdateMenuRequest request) throws RuntimeException {
        request.setMenuId(menuId);
        int result = this.menuBusiness.update(request);
        if (result > 0) {
            return CommonResponse.ok((String)"\u66f4\u65b0\u6210\u529f", (Object)true);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u66f4\u65b0");
    }
}

