/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.message.process;

import com.xforceplus.landedestate.basecommon.vaildate.Validator;
import com.xforceplus.vanke.sc.client.model.UpdateMessageRequest;
import com.xforceplus.vanke.sc.controller.common.process.DownloadFilesProcess;
import com.xforceplus.vanke.sc.repository.dao.SysMessageDao;
import com.xforceplus.vanke.sc.repository.model.SysMessageEntity;
import com.xforceplus.vanke.sc.repository.model.SysMessageExample;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UpdateMessageAndDownloadProcess
implements Validator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private SysMessageDao sysMessageDao;
    @Autowired
    private DownloadFilesProcess downloadFilesProcess;

    protected void check(UpdateMessageRequest request) throws ValidationException {
        this.checkEmpty((Object)request.getMessageId(), "messageId\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public ResponseEntity<byte[]> execute(UpdateMessageRequest request) {
        this.check(request);
        return this.process(request);
    }

    protected ResponseEntity<byte[]> process(UpdateMessageRequest request) throws RuntimeException {
        this.messageBusiness.updateByMessageId(request.getMessageId());
        SysMessageExample sysMessageExample = new SysMessageExample();
        sysMessageExample.createCriteria().andMessageIdEqualTo(request.getMessageId());
        SysMessageEntity sysMessageEntity = this.sysMessageDao.selectOneByExample(sysMessageExample);
        String url = sysMessageEntity.getMessageUrl();
        if (StringUtils.isEmpty((Object)url)) {
            return null;
        }
        ResponseEntity responseEntity = this.downloadFilesProcess.execute(url);
        this.logger.info("response:{}", (Object)responseEntity);
        return responseEntity;
    }
}

