/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.role.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.sc.client.model.GetRoleListRequest;
import com.xforceplus.vanke.sc.client.model.SysRoleDTO;
import com.xforceplus.vanke.sc.repository.dao.SysRoleDao;
import com.xforceplus.vanke.sc.repository.daoext.SysUserRoleDaoExt;
import com.xforceplus.vanke.sc.repository.model.SysRoleExample;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetRoleListProcess
extends AbstractProcess<GetRoleListRequest, ListResult<SysRoleDTO>> {
    @Autowired
    private SysRoleDao sysRoleDao;
    @Autowired
    private SysUserRoleDaoExt sysUserRoleDaoExt;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected CommonResponse<ListResult<SysRoleDTO>> process(GetRoleListRequest request) throws RuntimeException {
        SysRoleExample example = this.createExample(request);
        ListResult listResult = new ListResult(Long.valueOf(this.sysRoleDao.countByExample(example)), this.sysRoleDao.selectByExample(example));
        ListResult result = (ListResult)JSON.parseObject((String)JSON.toJSONString((Object)listResult), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
    }

    private SysRoleExample createExample(GetRoleListRequest request) {
        UserSessionInfo userInfo;
        SysRoleExample roleExample = new SysRoleExample();
        roleExample.setLimit(request.getRows());
        roleExample.setOffset(request.getOffset());
        SysRoleExample.Criteria criteria = roleExample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)request.getRoleName())) {
            criteria.andRoleNameLike(String.format("%%%s%%", request.getRoleName()));
        }
        if (request.getStatus() != null) {
            criteria.andStatusEqualTo(request.getStatus());
        }
        if (!(userInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo()).getIsAdmin()) {
            List roleIds = this.sysUserRoleDaoExt.selectRoleByUserId(Long.valueOf(userInfo.getAccountId()));
            criteria.andRoleIdIn(roleIds);
        }
        return roleExample;
    }
}

