/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.role.process;

import com.xforceplus.landedestate.basecommon.process.AbstractKeyProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.UpdateRoleRequest;
import com.xforceplus.vanke.sc.service.RoleBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UpdateRoleProcess
extends AbstractKeyProcess<Long, UpdateRoleRequest, Boolean> {
    @Autowired
    private RoleBusiness roleBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(Long roleId, UpdateRoleRequest request) throws ValidationException {
        super.check((Object)roleId, (BaseRequest)request);
        if (!((UserContext)this.contextHolder.get()).getUserSessionInfo().getIsAdmin()) {
            throw new ValidationException("\u975e\u7ba1\u7406\u5458\u65e0\u6cd5\u66f4\u65b0\u89d2\u8272");
        }
        this.checkEmpty(request.getRoleName(), "\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(Long roleId, UpdateRoleRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        }
        request.setRoleId(roleId);
        int result = this.roleBusiness.update(request);
        if (result > 0) {
            this.roleBusiness.deleteRoleMenu(roleId);
            if (!CollectionUtils.isEmpty((Collection)request.getMenuIdList())) {
                this.roleBusiness.batchInsertRoleMenu(roleId, request.getMenuIdList(), userSessionInfo);
            }
            return CommonResponse.ok((String)"\u66f4\u65b0\u6210\u529f", (Object)true);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u66f4\u65b0");
    }
}

