/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.user.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.sc.client.model.GetUserListRequest;
import com.xforceplus.vanke.sc.client.model.SysUserDTO;
import com.xforceplus.vanke.sc.repository.dao.SysUserDao;
import com.xforceplus.vanke.sc.repository.model.SysUserExample;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetUserListProcess
extends AbstractProcess<GetUserListRequest, ListResult<SysUserDTO>> {
    @Autowired
    private SysUserDao sysUserDao;

    protected CommonResponse<ListResult<SysUserDTO>> process(GetUserListRequest request) throws RuntimeException {
        SysUserExample example = new SysUserExample();
        SysUserExample.Criteria criteria = example.createCriteria();
        if (!StringHelp.safeIsEmpty((Object)request.getRealName())) {
            criteria.andRealNameLike("%" + request.getRealName() + "%");
        }
        if (!StringHelp.safeIsEmpty((Object)request.getUserName())) {
            criteria.andUserNameEqualTo(request.getUserName());
        }
        if (!StringHelp.safeIsEmpty((Object)request.getStatus())) {
            criteria.andStatusEqualTo(request.getStatus());
        }
        criteria.andUserNameNotEqualTo("admin");
        long count = this.sysUserDao.countByExample(example);
        example.setLimit(request.getRows());
        example.setOffset(request.getOffset());
        ListResult listResult = new ListResult(Long.valueOf(count), this.sysUserDao.selectByExample(example));
        ListResult result = (ListResult)JSON.parseObject((String)JSON.toJSONString((Object)listResult), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
    }
}

