/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.user.process;

import com.xforceplus.landedestate.basecommon.help.encryption.MD5Help;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.SaveUserRequest;
import com.xforceplus.vanke.sc.client.model.SysUserDTO;
import com.xforceplus.vanke.sc.service.UserBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaveUserProcess
extends AbstractProcess<SaveUserRequest, List<Long>> {
    @Autowired
    private UserBusiness userBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    private final String rex = "^(?=.*\\d)(?=.*[A-Za-z])[\\x20-\\x7e]{8,}$";

    protected void check(SaveUserRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        if (CollectionUtils.isEmpty((Collection)request.getEntities())) {
            throw new ValidationException("\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SysUserDTO entity : request.getEntities()) {
            this.checkEmpty(entity.getUserName(), "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getPassword(), "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getRealName(), "\u771f\u5b9e\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getType(), "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            if (entity.getPassword().matches("^(?=.*\\d)(?=.*[A-Za-z])[\\x20-\\x7e]{8,}$")) continue;
            throw new ValidationException("\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u5b57\u6bcd\u548c\u6570\u5b57\u4e14\u957f\u5ea6\u5927\u4e8e8\u4f4d\u4ee5\u4e0a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<List<Long>> process(SaveUserRequest request) throws RuntimeException {
        for (SysUserDTO entity2 : request.getEntities()) {
            if (this.userBusiness.selectUserByName(entity2.getUserName()) <= 0L) continue;
            return CommonResponse.failed((String)"\u8be5\u7528\u6237\u5df2\u5b58\u5728");
        }
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        }
        List keys = request.getEntities().stream().map(entity -> {
            entity.setType(Integer.valueOf(1));
            entity.setPassword(MD5Help.encode((String)entity.getPassword()));
            int result = this.userBusiness.insert((SysUserDTO)entity);
            if (result > 0) {
                if (!CollectionUtils.isEmpty((Collection)entity.getRoleIdList())) {
                    this.userBusiness.batchInsertUserRole(entity.getUserId(), entity.getRoleIdList(), userSessionInfo);
                }
                return entity.getUserId();
            }
            return null;
        }).collect(Collectors.toList());
        if (keys.stream().anyMatch(key -> key != null)) {
            if (keys.stream().anyMatch(key -> key == null)) {
                return CommonResponse.ok((String)"\u90e8\u5206\u65b0\u589e\u6210\u529f", keys);
            }
            return CommonResponse.ok((String)"\u65b0\u589e\u6210\u529f", keys);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u65b0\u589e");
    }
}

