/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.user.process;

import com.xforceplus.landedestate.basecommon.help.encryption.MD5Help;
import com.xforceplus.landedestate.basecommon.process.AbstractKeyProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.sc.client.model.UpdateUserRequest;
import com.xforceplus.vanke.sc.service.UserBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UpdateUserProcess
extends AbstractKeyProcess<Long, UpdateUserRequest, Boolean> {
    @Autowired
    private UserBusiness userBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(Long userId, UpdateUserRequest request) throws ValidationException {
        super.check((Object)userId, (BaseRequest)request);
        this.checkEmpty(request.getUserName(), "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getType(), "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (ValidatorUtil.isNotEmpty((String)request.getPassword())) {
            String rex = "^(?=.*\\d)(?=.*[A-Za-z])[\\x20-\\x7e]{8,}$";
            if (!request.getPassword().matches(rex)) {
                throw new ValidationException("\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u5b57\u6bcd\u548c\u6570\u5b57\u4e14\u957f\u5ea6\u5927\u4e8e8\u4f4d\u4ee5\u4e0a");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(Long userId, UpdateUserRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        }
        request.setUserId(userId);
        if (ValidatorUtil.isNotEmpty((String)request.getPassword())) {
            request.setPassword(MD5Help.encode((String)request.getPassword()));
        } else {
            request.setPassword(null);
        }
        int result = this.userBusiness.update(request);
        if (result > 0) {
            this.userBusiness.deleteUserRole(userId);
            if (!CollectionUtils.isEmpty((Collection)request.getRoleIdList())) {
                this.userBusiness.batchInsertUserRole(userId, request.getRoleIdList(), userSessionInfo);
            }
            return CommonResponse.ok((String)"\u66f4\u65b0\u6210\u529f", (Object)true);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u66f4\u65b0");
    }
}

