/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.user.process;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.help.JsonHelp;
import com.xforceplus.landedestate.basecommon.help.encryption.MD5Help;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.User.StatusEnum;
import com.xforceplus.vanke.sc.client.model.GetUserListRequest;
import com.xforceplus.vanke.sc.client.model.UserLoginRequest;
import com.xforceplus.vanke.sc.controller.user.dto.LoginResponse;
import com.xforceplus.vanke.sc.repository.dao.SysUserDao;
import com.xforceplus.vanke.sc.repository.model.SysUserEntity;
import com.xforceplus.xplatsecurity.api.TokenService;
import com.xforceplus.xplatsecurity.api.domain.TokenBody;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserLoginProcess
extends AbstractProcess<UserLoginRequest, LoginResponse> {
    @Autowired
    private SysUserDao sysUserDao;
    @Autowired
    private TokenService tokenService;
    @Value(value="${vankeSC.accessTokenValidTimeInSeconds:36000}")
    private long accessTokenValidTimeInSeconds;

    protected CommonResponse<LoginResponse> process(UserLoginRequest request) throws RuntimeException {
        String passwordMD5 = MD5Help.encode((String)request.getPassword());
        request.setPassword(passwordMD5);
        GetUserListRequest listRequest = (GetUserListRequest)JSON.parseObject((String)JSON.toJSONString((Object)request), GetUserListRequest.class);
        List users = this.sysUserDao.selectByEntity((PageRequest)listRequest);
        if (users.size() == 1) {
            SysUserEntity user = (SysUserEntity)users.get(0);
            if (!StatusEnum.ENABLE.getCode().equals(user.getStatus())) {
                return CommonResponse.failed((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
            }
            String token = this.createToken(user);
            LoginResponse loginResponse = new LoginResponse();
            loginResponse.setUserName(user.getUserName());
            loginResponse.setToken(token);
            return CommonResponse.ok((String)"\u767b\u9646\u6210\u529f", (Object)loginResponse);
        }
        return CommonResponse.failed((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
    }

    private String createToken(SysUserEntity user) {
        HashMap additionalProperties = Maps.newHashMap();
        UserSessionInfo userSessionInfo = new UserSessionInfo();
        userSessionInfo.setAccountId(user.getUserId().longValue());
        userSessionInfo.setEmail(user.getUserEmail());
        userSessionInfo.setGroupCode("");
        userSessionInfo.setGroupId(0L);
        userSessionInfo.setGroupName("");
        userSessionInfo.setIsAdmin(Constants.ADMIN_TYPE.equals(user.getType()));
        userSessionInfo.setMobile(user.getUserPhone());
        userSessionInfo.setSysUserId(user.getUserId().longValue());
        userSessionInfo.setSysUserName(user.getRealName());
        additionalProperties.put("userInfo", JsonHelp.toString((Object)userSessionInfo));
        String token = this.tokenService.createToken(new TokenBody(user.getRealName(), user.getRealName(), "0", this.accessTokenValidTimeInSeconds, (Map)additionalProperties));
        return token;
    }
}

