/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xforceplus.landedestate.basecommon.help.JsonHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.logger.entity.RequestLogEntity;
import com.xforceplus.landedestate.basecommon.logger.entity.ResponseLogEntity;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class WebLogAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    ThreadLocal<Long> startTime = new ThreadLocal();
    ThreadLocal<RequestLogEntity> req = new ThreadLocal();

    @Pointcut(value="execution(public * com.xforceplus.vanke.sc.controller..*Controller.*(..))")
    public void webLog() {
    }

    @Before(value="webLog()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        this.startTime.set(System.currentTimeMillis());
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            this.writeAppRequest(joinPoint, request);
        }
        catch (Exception ex) {
            this.logger.error("\u62e6\u622a\u53c2\u6570\u8bb0\u5f55\u4e0b\u8bf7\u6c42\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff1a" + ex);
        }
    }

    @AfterReturning(returning="ret", pointcut="webLog()")
    public void doAfterReturning(Object ret) {
        try {
            Long time = System.currentTimeMillis() - (Long)this.startTime.get();
            this.writeAppResponse((RequestLogEntity)this.req.get(), ret, time);
        }
        catch (Exception e) {
            this.logger.error("\u62e6\u622a\u8fd4\u56de\u8bb0\u5f55\u4e0b\u8fd4\u56de\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff1a" + e);
        }
    }

    private void writeAppRequest(JoinPoint joinPoint, HttpServletRequest request) {
        StringBuffer requestParm = new StringBuffer("");
        if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
            for (int i = 0; i < joinPoint.getArgs().length; ++i) {
                requestParm.append(JSON.toJSONString((Object)joinPoint.getArgs()[i], (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            }
        }
        RequestLogEntity logEntity = new RequestLogEntity();
        logEntity.setTitle("\u8bf7\u6c42\u62a5\u6587");
        logEntity.setName(StringHelp.safeLastSplit((String)request.getRequestURI(), (String)"/"));
        logEntity.setUrl(request.getRequestURL().toString());
        logEntity.setIp(request.getRemoteAddr());
        logEntity.setRequestStr(StringHelp.safeToString((Object)requestParm.toString()));
        this.req.set(logEntity);
        this.logger.debug(JsonHelp.toString((Object)logEntity));
    }

    private void writeAppResponse(RequestLogEntity reqEntity, Object ret, Long time) {
        ResponseLogEntity logEntity = new ResponseLogEntity();
        logEntity.setTitle("\u8fd4\u56de\u62a5\u6587");
        logEntity.setName(reqEntity.getName());
        logEntity.setUrl(reqEntity.getUrl());
        logEntity.setIp(reqEntity.getIp());
        logEntity.setResponseStr(JsonHelp.toString((Object)ret));
        logEntity.setTime(time);
        this.logger.debug(JsonHelp.toString((Object)logEntity));
    }
}

