/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.common.process;

import com.xforceplus.landedestate.basecommon.vaildate.Validator;
import com.xforceplus.vanke.sc.service.FileBusiness;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.validation.ValidationException;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DownloadFilesProcess
implements Validator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FileBusiness fileBusiness;

    public ResponseEntity<byte[]> execute(String fileKey) {
        this.check(fileKey);
        return this.process(fileKey);
    }

    private void check(String fileKey) throws ValidationException {
        this.checkEmpty(fileKey, "\u6587\u4ef6key\u4e0d\u80fd\u4e3a\u7a7a");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseEntity<byte[]> process(String fileKey) throws RuntimeException {
        HttpHeaders headers = new HttpHeaders();
        this.logger.info("------------------------\u4e0b\u8f7d\u6587\u4ef6  fileKey:{}", (Object)fileKey);
        try (InputStream is = this.fileBusiness.getFile(fileKey);){
            this.logger.info("------------------------\u4e0b\u8f7d\u6587\u4ef6  InputStream:{}", (Object)is.markSupported());
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            this.logger.info("------------------------\u4e0b\u8f7d\u6587\u4ef6  bytes:{}", (Object)bytes.length);
            String fileName = fileKey.substring(fileKey.lastIndexOf("/") + 1);
            headers.setContentDispositionFormData("attachment", URLEncoder.encode(fileName, "utf-8"));
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)bytes);
            return responseEntity;
        }
        catch (IOException e) {
            this.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return ResponseEntity.notFound().build();
        }
    }
}

