/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.company.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.sc.client.model.GetCompanyListRequest;
import com.xforceplus.vanke.sc.client.model.WkCompanyDTO;
import com.xforceplus.vanke.sc.repository.dao.WkCompanyDao;
import com.xforceplus.vanke.sc.repository.model.WkCompanyExample;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetCompanyListProcess
extends AbstractProcess<GetCompanyListRequest, ListResult<WkCompanyDTO>> {
    @Autowired
    private WkCompanyDao wkCompanyDao;

    protected CommonResponse<ListResult<WkCompanyDTO>> process(GetCompanyListRequest request) throws RuntimeException {
        WkCompanyExample wkCompanyExample = this.getExample(request);
        if (request.getRows() != null && request.getOffset() != null) {
            wkCompanyExample.setLimit(request.getRows());
            wkCompanyExample.setOffset(request.getOffset());
        }
        ListResult listResult = new ListResult(Long.valueOf(this.wkCompanyDao.countByExample(wkCompanyExample)), this.wkCompanyDao.selectByExample(wkCompanyExample));
        ListResult result = new ListResult(listResult.getTotal(), listResult.getList().stream().map(entity -> {
            WkCompanyDTO dto = new WkCompanyDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
    }

    public WkCompanyExample getExample(GetCompanyListRequest request) {
        WkCompanyExample wkCompanyExample = new WkCompanyExample();
        WkCompanyExample.Criteria criteria = wkCompanyExample.createCriteria();
        if (StringUtils.isNotEmpty((CharSequence)request.getCompanyName())) {
            criteria.andCompanyNameLike("%" + request.getCompanyName() + "%");
        }
        if (request.getIsSynergetics() != null) {
            criteria.andIsSynergeticsEqualTo(request.getIsSynergetics());
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getAuditState())) {
            criteria.andAuditStateIn(request.getAuditState());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getCompanyTaxNo())) {
            criteria.andCompanyTaxNoEqualTo(request.getCompanyTaxNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getAlterationTime()) && request.getAlterationTime().size() == 2) {
            criteria.andAlterationTimeBetween(new Date((Long)request.getAlterationTime().get(0)), new Date((Long)request.getAlterationTime().get(1)));
        }
        wkCompanyExample.setOrderByClause("company_id desc");
        return wkCompanyExample;
    }
}

