/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.config.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.SaveConfigRequest;
import com.xforceplus.vanke.sc.client.model.SysConfigDTO;
import com.xforceplus.vanke.sc.repository.dao.SysConfigDao;
import com.xforceplus.vanke.sc.repository.model.SysConfigExample;
import com.xforceplus.vanke.sc.service.ConfigBusiness;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaveConfigProcess
extends AbstractProcess<SaveConfigRequest, List<Long>> {
    @Autowired
    private ConfigBusiness configBusiness;
    @Autowired
    private SysConfigDao sysConfigDao;

    protected void check(SaveConfigRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        if (CollectionUtils.isEmpty((Collection)request.getEntities())) {
            throw new ValidationException("\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SysConfigDTO entity : request.getEntities()) {
            this.checkEmpty((Object)entity.getConfigType(), "\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getConfigKey(), "\u914d\u7f6e\u7684\u952e\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getConfigValue(), "\u914d\u7f6e\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getConfigDesc(), "\u914d\u7f6e\u7684\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected CommonResponse<List<Long>> process(SaveConfigRequest request) throws RuntimeException {
        for (SysConfigDTO entity2 : request.getEntities()) {
            if (!"email".equals(entity2.getConfigKey())) continue;
            SysConfigExample example = new SysConfigExample();
            example.createCriteria().andConfigValueEqualTo(entity2.getConfigValue());
            long l = this.sysConfigDao.countByExample(example);
            if (l <= 0L) continue;
            return CommonResponse.failed((String)"\u65b0\u589e\u5931\u8d25,\u90ae\u7bb1\u8bf7\u52ff\u91cd\u590d!");
        }
        List keys = request.getEntities().stream().map(entity -> {
            int result = this.configBusiness.insert(entity);
            if (result > 0) {
                return entity.getConfigId();
            }
            return null;
        }).collect(Collectors.toList());
        if (keys.stream().anyMatch(key -> key != null)) {
            if (keys.stream().anyMatch(key -> key == null)) {
                return CommonResponse.ok((String)"\u90e8\u5206\u65b0\u589e\u6210\u529f", keys);
            }
            return CommonResponse.ok((String)"\u65b0\u589e\u6210\u529f", keys);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u65b0\u589e,\u8bf7\u68c0\u67e5\u683c\u5f0f\u53ca\u957f\u5ea6");
    }
}

