/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.legalperson.process;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.sc.base.enums.company.IsBlockadeEnum;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import com.xforceplus.vanke.sc.client.model.CheckConfirmRequest;
import com.xforceplus.vanke.sc.outer.pyt.PYTInterfaceImpl;
import com.xforceplus.vanke.sc.repository.dao.WkLegalPersonDao;
import com.xforceplus.vanke.sc.repository.daoext.WkLegalPersonDaoExt;
import com.xforceplus.vanke.sc.repository.model.CheckConfirmRequestData;
import com.xforceplus.vanke.sc.repository.model.CheckCountModel;
import com.xforceplus.vanke.sc.repository.model.RequestDataModel;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonEntity;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonExample;
import com.xforceplus.xplatframework.utils.json.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckConfirmLegalPersonProcess
extends AbstractProcess<CheckConfirmRequest, String> {
    @Autowired
    private WkLegalPersonDaoExt wkLegalPersonDaoExt;
    @Autowired
    private WkLegalPersonDao wkLegalPersonDao;
    @Autowired
    private PYTInterfaceImpl pytInterface;

    protected void check(CheckConfirmRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getRelTax(), "\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    protected CommonResponse<String> process(CheckConfirmRequest request) throws RuntimeException {
        List relTax = request.getRelTax();
        ArrayList result = Lists.newArrayList();
        StringBuffer stringBuffer = new StringBuffer("");
        List checkList = this.wkLegalPersonDaoExt.checkConfirmCount(relTax);
        ArrayList authingTaxNoList = Lists.newArrayList();
        if (ValidatorUtil.isNotEmpty((Collection)checkList) && ((CheckCountModel)checkList.get(0)).getConfirmCount() > 0L) {
            checkList.stream().forEach(check -> {
                if (check.getConfirmCount() > 0L) {
                    authingTaxNoList.add(check.getPurchaserTaxNo());
                    stringBuffer.append("\u7a0e\u53f7[" + check.getPurchaserTaxNo() + "]\u6709\u52fe\u9009\u4e2d\u7684\u53d1\u7968\u6570:" + check.getConfirmCount()).append("\n");
                }
            });
        }
        relTax.stream().forEach(s -> {
            if (!authingTaxNoList.contains(s)) {
                result.add(s);
            }
        });
        if (ValidatorUtil.isEmpty((Collection)result)) {
            return CommonResponse.failed((String)("\u53d1\u8d77\u52fe\u9009\u786e\u8ba4\u5931\u8d25:" + stringBuffer.toString()));
        }
        List checkConfirmModelList = this.wkLegalPersonDaoExt.checkConfirm((List)result);
        checkConfirmModelList.stream().forEach(checkConfirmModel -> {
            if (ValidatorUtil.isEmpty((String)checkConfirmModel.getPeriod()) || !DateHelp.getMonth().equals(checkConfirmModel.getPeriod())) {
                checkConfirmModel.setPeriod(DateHelp.getLastMonth());
            }
        });
        String url = "";
        try {
            RequestDataModel requestDataModel = new RequestDataModel();
            CheckConfirmRequestData requestData = new CheckConfirmRequestData();
            requestData.setCompanies(checkConfirmModelList);
            requestData.setPlatform("phoenix");
            requestData.setTenantNo("SC@Vanke");
            requestData.setUserId("Vanke");
            requestDataModel.setRequestData(requestData);
            String param = JsonUtils.writeObjectToJson((Object)requestDataModel);
            JSONObject accessTokenJson = this.pytInterface.getFetchToken();
            String accessToken = (String)accessTokenJson.get((Object)"body");
            if (null == accessTokenJson) {
                throw new VankeException("\u672a\u83b7\u53d6\u5230token!");
            }
            JSONObject keyJson = this.pytInterface.getAuthCompanies(param);
            String resultKey = (String)keyJson.get((Object)"result");
            int code = keyJson.getIntValue("code");
            if (1 != code) {
                throw new VankeException("\u83b7\u53d6key\u5931\u8d25!");
            }
            url = this.pytInterface.getDeductionStatist(accessToken, resultKey);
            if (ValidatorUtil.isEmpty((String)url)) {
                this.logger.error("\u83b7\u53d6Url\u5931\u8d25!");
                throw new VankeException("\u83b7\u53d6Url\u4e3a\u7a7a!");
            }
            this.logger.error("\u8df3\u8f6curl={}", (Object)url);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e1a\u52a1\u4e2d\u53f0token\u548ckey\u5931\u8d25errorMessage: {}", (Object)e.getMessage());
            return CommonResponse.failed((String)("\u53d1\u8d77\u7edf\u8ba1\u786e\u8ba4\u5931\u8d25:" + e.getMessage()));
        }
        String message = "\u53d1\u8d77\u52fe\u9009\u6210\u529f!  " + stringBuffer.toString();
        return CommonResponse.ok((String)message, (Object)url);
    }

    public long updateIsBlockade(List<String> relTaxList) {
        WkLegalPersonExample wkLegalPersonExample = new WkLegalPersonExample();
        wkLegalPersonExample.createCriteria().andRelTaxIn(relTaxList);
        WkLegalPersonEntity wkLegalPersonEntity = new WkLegalPersonEntity();
        wkLegalPersonEntity.setIsBlockade(IsBlockadeEnum.BLOCK.getCode());
        return this.wkLegalPersonDao.updateByExampleSelective(wkLegalPersonEntity, wkLegalPersonExample);
    }
}

