/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.legalperson.process;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.excel.EasyExcelHelp;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.company.IsBlockadeEnum;
import com.xforceplus.vanke.sc.client.model.GetLegalPersonListRequest;
import com.xforceplus.vanke.sc.controller.legalperson.process.GetLegalPersonListProcess;
import com.xforceplus.vanke.sc.repository.dao.WkLegalPersonDao;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonExample;
import com.xforceplus.vanke.sc.repository.params.LegalPersonExportBean;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EasyExportLegalPersonProcess
extends AbstractProcess<GetLegalPersonListRequest, Boolean> {
    @Autowired
    private WkLegalPersonDao wkLegalPersonDao;
    @Autowired
    private FileBusiness fileBusiness;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private GetLegalPersonListProcess getLegalPersonListProcess;

    protected void check(GetLegalPersonListRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<Boolean> process(GetLegalPersonListRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        CompletableFuture.runAsync(() -> {
            WkLegalPersonExample wkLegalPersonExample = this.getLegalPersonListProcess.getWkLegalPseronExample(request);
            List legalPersonEntityList = this.wkLegalPersonDao.selectByExample(wkLegalPersonExample);
            ArrayList beanList = Lists.newArrayList();
            legalPersonEntityList.stream().forEach(entity -> {
                LegalPersonExportBean legalPersonExportBean = new LegalPersonExportBean();
                BeanUtils.copyProperties((Object)entity, (Object)legalPersonExportBean);
                legalPersonExportBean.setUpdateTime(entity.getUpdateTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)entity.getUpdateTime()));
                IsBlockadeEnum isBlockadeEnum = IsBlockadeEnum.fromCode((Integer)entity.getIsBlockade());
                legalPersonExportBean.setIsBlockade(isBlockadeEnum == null ? "" : isBlockadeEnum.getName());
                beanList.add(legalPersonExportBean);
            });
            ByteArrayOutputStream outputStream = EasyExcelHelp.export((List)beanList, (String)"\u6cd5\u4eba\u4e3b\u6570\u636e", LegalPersonExportBean.class);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            String fileName = String.format("\u6cd5\u4eba\u4e3b\u6570\u636e\u5bfc\u51fa_%s%s", DateUtils.curDateStr((String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206"), ExcelTypeEnum.XLSX.getValue());
            String key = this.fileBusiness.uploadFile(fileName, (InputStream)inputStream);
            String messageContent = key == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s", DateUtils.curDateStr((String)"yyyy.MM.dd HH:mm:ss"));
            this.messageBusiness.insert(Long.valueOf(userSessionInfo.getSysUserId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, messageContent, key, new Date(), Long.valueOf(userSessionInfo.getSysUserId()), userSessionInfo.getSysUserName());
        });
        return CommonResponse.ok((String)"\u5bfc\u51fa\u6210\u529f,\u8bf7\u5728\u53f3\u4e0a\u89d2\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b!");
    }
}

