/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.legalperson.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.sc.client.model.GetLegalPersonListRequest;
import com.xforceplus.vanke.sc.client.model.WkLegalPersonDTO;
import com.xforceplus.vanke.sc.repository.dao.WkLegalPersonDao;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonExample;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetLegalPersonListProcess
extends AbstractProcess<GetLegalPersonListRequest, ListResult<WkLegalPersonDTO>> {
    @Autowired
    private WkLegalPersonDao wkLegalPersonDao;

    protected CommonResponse<ListResult<WkLegalPersonDTO>> process(GetLegalPersonListRequest request) throws RuntimeException {
        WkLegalPersonExample example = this.getWkLegalPseronExample(request);
        if (request.getRows() != null && request.getOffset() != null) {
            example.setLimit(request.getRows());
            example.setOffset(request.getOffset());
        }
        ListResult listResult = new ListResult(Long.valueOf(this.wkLegalPersonDao.countByExample(example)), this.wkLegalPersonDao.selectByExample(example));
        ListResult result = new ListResult(listResult.getTotal(), listResult.getList().stream().map(entity -> {
            WkLegalPersonDTO dto = new WkLegalPersonDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
    }

    public WkLegalPersonExample getWkLegalPseronExample(GetLegalPersonListRequest request) {
        String time;
        WkLegalPersonExample example = new WkLegalPersonExample();
        WkLegalPersonExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty((String)request.getName())) {
            criteria.andNameLike("%" + request.getName() + "%");
        }
        if (StringUtils.isNotEmpty((String)request.getTaxPayer())) {
            criteria.andTaxPayerLike("%" + request.getTaxPayer() + "%");
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getAuditState())) {
            criteria.andAuditStateIn(request.getAuditState());
        }
        if (request.getIsSynergetics() != null) {
            criteria.andIsSynergeticsEqualTo(request.getIsSynergetics());
        }
        if (request.getAuthType() != null) {
            criteria.andAuthTypeEqualTo(request.getAuthType());
        }
        if (StringUtils.isNotEmpty((String)request.getIsUseElserver())) {
            criteria.andIsUseElserverEqualTo(request.getIsUseElserver());
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getAlterationTime()) && request.getAlterationTime().size() == 2) {
            criteria.andAlterationTimeBetween(new Date((Long)request.getAlterationTime().get(0)), new Date((Long)request.getAlterationTime().get(1)));
        }
        if (null != request.getPeriodDate() && !StringHelp.safeIsEmpty((Object)(time = DateHelp.getMonthString((Date)new Date(request.getPeriodDate()))))) {
            criteria.andPeriodDateEqualTo(time);
        }
        if (!StringHelp.safeIsEmpty((Object)request.getRelTax())) {
            criteria.andRelTaxLike("%" + request.getRelTax() + "%");
        }
        if (null != request.getIsBlockade()) {
            criteria.andIsBlockadeEqualTo(request.getIsBlockade());
        }
        example.setOrderByClause("legalPersonId desc");
        return example;
    }
}

