/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.legalperson.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.sc.base.enums.company.AuthTypeEnum;
import com.xforceplus.vanke.sc.base.enums.company.IsBlockadeEnum;
import com.xforceplus.vanke.sc.base.enums.company.IsUseElserverEnum;
import com.xforceplus.vanke.sc.base.enums.company.OperationTypeEnum;
import com.xforceplus.vanke.sc.base.mqqueue.JcQueue;
import com.xforceplus.vanke.sc.client.model.UpdateLegalPersonRequest;
import com.xforceplus.vanke.sc.repository.dao.LogMaininfoDao;
import com.xforceplus.vanke.sc.repository.dao.WkLegalPersonDao;
import com.xforceplus.vanke.sc.repository.model.LogMaininfoEntity;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonEntity;
import com.xforceplus.vanke.sc.utils.JcHttpsSender;
import com.xforceplus.xplatframework.utils.json.JsonUtils;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.Date;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateLegalPersonProcess
extends AbstractProcess<UpdateLegalPersonRequest, Boolean> {
    @Autowired
    private LogMaininfoDao logMaininfoDao;
    @Autowired
    private WkLegalPersonDao wkLegalPersonDao;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private JcHttpsSender jcHttpsSender;

    protected void check(UpdateLegalPersonRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getLegalPersonId(), "\u6cd5\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getNumber(), "\u516c\u53f8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Boolean> process(UpdateLegalPersonRequest request) throws RuntimeException {
        int count;
        String oldAuthType;
        String authType;
        boolean flag = false;
        this.logger.info("\u4fee\u6539\u62b5\u6263\u65b9\u5f0f\u3001\u662f\u5426\u5e95\u8d26\u670d\u52a1 ", (Object)JsonUtils.writeObjectToJson((Object)request));
        WkLegalPersonEntity oldLegalPersonEntity = this.wkLegalPersonDao.selectByPrimaryKey(request.getLegalPersonId());
        StringBuilder stringBuilder = new StringBuilder();
        LogMaininfoEntity logMaininfoEntity = new LogMaininfoEntity();
        WkLegalPersonEntity wkLegalPersonEntity = new WkLegalPersonEntity();
        wkLegalPersonEntity.setLegalPersonId(request.getLegalPersonId());
        if (ValidatorUtil.isNotEmpty((String)request.getIsUseElserver()) && !oldLegalPersonEntity.getIsUseElserver().equals(request.getIsUseElserver())) {
            wkLegalPersonEntity.setIsUseElserver(request.getIsUseElserver());
            IsUseElserverEnum isUseElserverEnum = IsUseElserverEnum.fromCode((String)request.getIsUseElserver());
            IsUseElserverEnum oldIsisUseElserverEnum = IsUseElserverEnum.fromCode((String)oldLegalPersonEntity.getIsUseElserver());
            String isUseElserver = isUseElserverEnum == null ? "" : isUseElserverEnum.getName();
            String oldIsUseElserver = oldIsisUseElserverEnum == null ? "" : oldIsisUseElserverEnum.getName();
            stringBuilder.append("\u5e95\u8d26\u670d\u52a1\u5668 (" + oldIsUseElserver + " -> " + isUseElserver + "); \n");
            logMaininfoEntity.setOperationDesc(stringBuilder.toString());
        }
        if (ValidatorUtil.isNotEmpty((Object)request.getAuthType()) && !oldLegalPersonEntity.getAuthType().equals(request.getAuthType())) {
            wkLegalPersonEntity.setAuthType(request.getAuthType());
            AuthTypeEnum authTypeEnum = AuthTypeEnum.fromCode((Integer)request.getAuthType());
            AuthTypeEnum oldAuthTypeEnum = AuthTypeEnum.fromCode((Integer)oldLegalPersonEntity.getAuthType());
            authType = authTypeEnum == null ? "" : authTypeEnum.getName();
            oldAuthType = oldAuthTypeEnum == null ? "" : oldAuthTypeEnum.getName();
            stringBuilder.append("\u62b5\u6263\u65b9\u5f0f (" + oldAuthType + "->" + authType + "); \n");
            logMaininfoEntity.setOperationDesc(stringBuilder.toString());
        }
        if (ValidatorUtil.isNotEmpty((Object)request.getIsBlockade()) && !oldLegalPersonEntity.getIsBlockade().equals(request.getIsBlockade())) {
            wkLegalPersonEntity.setIsBlockade(request.getIsBlockade());
            IsBlockadeEnum isBlockadeEnum = IsBlockadeEnum.fromCode((Integer)request.getIsBlockade());
            IsBlockadeEnum oldIsBlockadeEnum = IsBlockadeEnum.fromCode((Integer)oldLegalPersonEntity.getIsBlockade());
            authType = isBlockadeEnum == null ? "" : isBlockadeEnum.getName();
            oldAuthType = oldIsBlockadeEnum == null ? "" : oldIsBlockadeEnum.getName();
            stringBuilder.append("\u662f\u5426\u5c01\u9501 (" + oldAuthType + "->" + authType + ");");
            logMaininfoEntity.setOperationDesc(stringBuilder.toString());
            flag = true;
        }
        if ((count = this.wkLegalPersonDao.updateByPrimaryKeySelective(wkLegalPersonEntity)) > 0) {
            logMaininfoEntity.setNumber(request.getNumber());
            logMaininfoEntity.setTaxNo(request.getTaxNo());
            logMaininfoEntity.setOperationType(OperationTypeEnum.UPDATE.getCode());
            logMaininfoEntity.setOperationTime(new Date());
            logMaininfoEntity.setOperationName(((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName());
            this.logMaininfoDao.insertSelective(logMaininfoEntity);
            if (flag) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("userName", (Object)((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName());
                jsonObject.put("taxNum", (Object)request.getTaxNo());
                jsonObject.put("status", (Object)request.getIsBlockade());
                this.jcHttpsSender.send(JcQueue.FP_JC_AUTHENTICATION, jsonObject.toJSONString(), request.getTaxNo(), null);
            }
        }
        return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f", (Object)true);
    }
}

