/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.logapi.process;

import com.alibaba.fastjson.JSON;
import com.siit.image.util.SiitTool;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.GetLogInterfaceListRequest;
import com.xforceplus.vanke.sc.outer.api.imsApi.gx.gxClientCode.Data;
import com.xforceplus.vanke.sc.outer.api.imsApi.gx.gxClientCode.HEADER;
import com.xforceplus.vanke.sc.outer.api.imsApi.gx.gxInvoiceUpdate.SYNEXCHANGEDATA;
import com.xforceplus.vanke.sc.outer.api.imsApi.gx.gxSalesbillSend.CompanySettlementInsertData;
import com.xforceplus.vanke.sc.outer.api.imsApi.gx.gxSalesbillSend.IMSI_REQUEST;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.invoicefp.v1.InvoiceStatusInfo;
import com.xforceplus.vanke.sc.outer.api.imsApi.vanke.pdc.settlementresult.v1.SettlementResultInfo;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.invoice.InvoiceAuth;
import com.xforceplus.vanke.sc.outer.api.imsCore.util.HttpUtils;
import com.xforceplus.vanke.sc.outer.eas.EASInterfaceImpl;
import com.xforceplus.vanke.sc.outer.gx.GXInterfaceImpl;
import com.xforceplus.vanke.sc.outer.sap.SAPInterfaceImpl;
import com.xforceplus.vanke.sc.repository.dao.LogApiDao;
import com.xforceplus.vanke.sc.repository.model.LogApiEntity;
import com.xforceplus.vanke.sc.repository.model.LogApiExample;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GetLogApiInterfaceLog
extends AbstractProcess<GetLogInterfaceListRequest, Map> {
    @Autowired
    private LogApiDao logApiDao;
    @Autowired
    private GXInterfaceImpl gxInterfaceImpl;
    @Autowired
    private EASInterfaceImpl easInterfaceImpl;
    @Autowired
    private SAPInterfaceImpl sapInterfaceImpl;
    @Value(value="${apiUrl}")
    private String apiUrl;

    protected CommonResponse<Map> process(GetLogInterfaceListRequest request) throws RuntimeException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> gxMethodList = Arrays.asList("fpSiittimerSynInvoiceGx", "fpInvoiceUpdateOrDeleteGx", "fpSynInvoiceImageGx", "fpNoCooperativeInvoiceGx", "fpCompanySettlementInsertNoConcerGX", "fpCompanySettlementInsertGX");
        List<String> easMethodList = Arrays.asList("fpUpdateSevenElementEas", "fpUpdateAutoCheckEas", "fpUpdateIsCertificatingEas");
        List<String> sapMethodList = Arrays.asList("fpSettlementResultSap", "fpInvoiceStatusResultSap", "fpInvoiceCancelVerifySap", "fpLegalPersonReceiveResultSap", "fpCompanyInfoResultSap", "fpCompanySettlementInsertSap");
        ArrayList<String> methodList = new ArrayList<String>();
        methodList.addAll(gxMethodList);
        methodList.addAll(easMethodList);
        methodList.addAll(sapMethodList);
        List ids = request.getIds();
        long count = ids.parallelStream().filter(item -> {
            boolean result = false;
            try {
                LogApiExample example = new LogApiExample();
                example.createCriteria().andApiLogIdEqualTo(item);
                LogApiEntity logApiEntity = this.logApiDao.selectOneByExample(example);
                if (null != logApiEntity) {
                    String methodName = logApiEntity.getMethodName();
                    String params = logApiEntity.getParams();
                    if (methodList.contains(methodName)) {
                        if ("fpSiittimerSynInvoiceGx".equalsIgnoreCase(methodName)) {
                            result = this.fpSiittimerSynInvoiceGx(params);
                        } else if ("fpSynInvoiceImageGx".equalsIgnoreCase(methodName)) {
                            result = this.fpSynInvoiceImageGx(params);
                        } else if ("fpNoCooperativeInvoiceGx".equalsIgnoreCase(methodName)) {
                            result = this.fpNoCooperativeInvoiceGx(params);
                        } else if ("fpInvoiceUpdateOrDeleteGx".equalsIgnoreCase(methodName)) {
                            result = this.fpInvoiceUpdateOrDeleteGx(params);
                        } else if ("fpUpdateSevenElementEas".equalsIgnoreCase(methodName)) {
                            result = this.fpUpdateSevenElementEas(params);
                        } else if ("fpUpdateAutoCheckEas".equalsIgnoreCase(methodName)) {
                            result = this.fpUpdateAutoCheckEas(params);
                        } else if ("fpUpdateIsCertificatingEas".equalsIgnoreCase(methodName)) {
                            result = this.fpUpdateIsCertificatingEas(params);
                        } else if ("fpSettlementResultSap".equalsIgnoreCase(methodName)) {
                            result = this.fpSettlementResultSap(params);
                        } else if ("fpInvoiceStatusResultSap".equalsIgnoreCase(methodName)) {
                            result = this.fpInvoiceStatusResultSap(params);
                        } else if ("fpInvoiceCancelVerifySap".equalsIgnoreCase(methodName)) {
                            result = this.fpInvoiceCancelVerifySap(params);
                        } else if ("fpLegalPersonReceiveResultSap".equalsIgnoreCase(methodName)) {
                            result = this.fpLegalPersonReceiveResultSap(params);
                        } else if ("fpCompanyInfoResultSap".equalsIgnoreCase(methodName)) {
                            result = this.fpCompanyInfoResultSap(params);
                        } else if ("fpCompanySettlementInsertSap".equalsIgnoreCase(methodName)) {
                            result = this.fpCompanySettlementInsertSap(params);
                        } else if ("fpCompanySettlementInsertNoConcerGX".equalsIgnoreCase(methodName)) {
                            result = this.fpCompanySettlementInsertNoConcerGX(params);
                        } else if ("fpCompanySettlementInsertGX".equalsIgnoreCase(methodName)) {
                            result = this.fpCompanySettlementInsertGX(params);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }).count();
        map.put("message", "\u6267\u884c" + ids.size() + "\u6761\u6570\u636e,\u6210\u529f" + count + "\u6761\u6570\u636e");
        map.put("result", 200);
        return CommonResponse.ok((String)"", map);
    }

    private boolean fpSiittimerSynInvoiceGx(String params) throws Exception {
        Data data;
        boolean result = false;
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)params);
        com.alibaba.fastjson.JSONObject headerJson = jsonObject.getJSONObject("header");
        com.alibaba.fastjson.JSONObject dateJson = jsonObject.getJSONObject("date");
        HEADER header = (HEADER)com.alibaba.fastjson.JSONObject.toJavaObject((JSON)headerJson, HEADER.class);
        String response = this.gxInterfaceImpl.SiitTimerSynInvoiceService(header, data = (Data)com.alibaba.fastjson.JSONObject.toJavaObject((JSON)dateJson, Data.class));
        if ("0".equalsIgnoreCase(response)) {
            result = true;
        }
        return result;
    }

    private boolean fpSynInvoiceImageGx(String params) throws Exception {
        com.alibaba.fastjson.JSONObject jsonObject;
        boolean result = false;
        com.alibaba.fastjson.JSONObject paramsJsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)params);
        String settlementNo = paramsJsonObject.getString("settlementNo");
        String time = DateHelp.getTimeShortString((Date)new Date());
        String vls = SiitTool.getValiStr((String[])new String[]{time, settlementNo});
        paramsJsonObject.put("time", (Object)time);
        paramsJsonObject.put("vls", (Object)vls);
        String response = this.gxInterfaceImpl.synInvoiceImage(paramsJsonObject.toJSONString());
        if (response.contains("result") && "0".equalsIgnoreCase((jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)response)).getString("result"))) {
            result = true;
        }
        return result;
    }

    private boolean fpNoCooperativeInvoiceGx(String params) throws Exception {
        boolean result = false;
        String url = this.apiUrl + "api/vanke-api/v1/gx/noCooperativeInvoice";
        String json = HttpUtils.doJsonPost((String)url, (String)params);
        com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)json);
        String code = jsonObject.getJSONObject("result").getString("code");
        if ("200".equals(code)) {
            result = true;
        }
        return result;
    }

    private boolean fpInvoiceUpdateOrDeleteGx(String params) throws Exception {
        boolean result = false;
        SYNEXCHANGEDATA synexchangedata = (SYNEXCHANGEDATA)com.alibaba.fastjson.JSONObject.toJavaObject((JSON)JSON.parseObject((String)params), SYNEXCHANGEDATA.class);
        String resultStr = this.gxInterfaceImpl.invoiceUpdateOrDelete(synexchangedata);
        com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)resultStr);
        com.alibaba.fastjson.JSONObject mESSAGE = jsonObject.getJSONObject("mESSAGE");
        String rESULT = mESSAGE.getString("rESULT");
        if ("S0M1".equals(rESULT)) {
            result = true;
        }
        return result;
    }

    private boolean fpUpdateSevenElementEas(String params) throws Exception {
        boolean result = false;
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)params);
        String resultStr = this.easInterfaceImpl.updateSevenElement(jsonObject);
        com.alibaba.fastjson.JSONObject resultJson = com.alibaba.fastjson.JSONObject.parseObject((String)resultStr);
        String code = resultJson.getString("code");
        if ("200".equals(code)) {
            result = true;
        }
        return result;
    }

    private boolean fpUpdateAutoCheckEas(String params) throws Exception {
        Integer autoCheckStatus;
        boolean result = false;
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)params);
        String orderCode = jsonObject.getString("orderCode");
        String resultStr = this.easInterfaceImpl.updateAutoCheck(orderCode, autoCheckStatus = jsonObject.getInteger("autoCheckStatus"));
        com.alibaba.fastjson.JSONObject resultJson = com.alibaba.fastjson.JSONObject.parseObject((String)resultStr);
        String code = resultJson.getString("code");
        if ("200".equals(code)) {
            result = true;
        }
        return result;
    }

    private boolean fpUpdateIsCertificatingEas(String params) throws Exception {
        boolean result = false;
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)params);
        InvoiceAuth invoiceAuth = (InvoiceAuth)com.alibaba.fastjson.JSONObject.toJavaObject((JSON)jsonObject, InvoiceAuth.class);
        String resultStr = this.easInterfaceImpl.updateIsCertificating(invoiceAuth);
        com.alibaba.fastjson.JSONObject resultJson = com.alibaba.fastjson.JSONObject.parseObject((String)resultStr);
        String code = resultJson.getString("code");
        if ("200".equals(code)) {
            result = true;
        }
        return result;
    }

    private boolean fpSettlementResultSap(String params) throws Exception {
        boolean result = false;
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)params);
        SettlementResultInfo settlementResultInfo = (SettlementResultInfo)com.alibaba.fastjson.JSONObject.toJavaObject((JSON)jsonObject, SettlementResultInfo.class);
        String resultStr = this.sapInterfaceImpl.settlementResult(settlementResultInfo);
        com.alibaba.fastjson.JSONObject resultJson = com.alibaba.fastjson.JSONObject.parseObject((String)resultStr);
        String sTATUSCODE = resultJson.getString("sTATUSCODE");
        if ("S000".equals(sTATUSCODE)) {
            result = true;
        }
        return result;
    }

    private boolean fpInvoiceStatusResultSap(String params) throws Exception {
        boolean result = false;
        com.alibaba.fastjson.JSONArray jsonArray = com.alibaba.fastjson.JSONArray.parseArray((String)params);
        List invoiceResults = com.alibaba.fastjson.JSONArray.parseArray((String)jsonArray.toString(), InvoiceStatusInfo.class);
        JSONArray resultJsonArray = this.sapInterfaceImpl.invoiceStatusResults(invoiceResults);
        JSONObject jsonObject = resultJsonArray.getJSONObject(0);
        String statuscode = jsonObject.getString("STATUSCODE");
        if ("S000".equals(statuscode)) {
            result = true;
        }
        return result;
    }

    private boolean fpInvoiceCancelVerifySap(String params) throws Exception {
        boolean result = false;
        com.alibaba.fastjson.JSONArray jsonArray = com.alibaba.fastjson.JSONArray.parseArray((String)params);
        List invoiceResults = com.alibaba.fastjson.JSONArray.parseArray((String)jsonArray.toString(), InvoiceStatusInfo.class);
        JSONArray resultJsonArray = this.sapInterfaceImpl.invoiceCancelVerify(invoiceResults);
        JSONObject jsonObject = resultJsonArray.getJSONObject(0);
        String statuscode = jsonObject.getString("STATUSCODE");
        if ("S000".equals(statuscode)) {
            result = true;
        }
        return result;
    }

    private boolean fpLegalPersonReceiveResultSap(String params) throws Exception {
        boolean result = true;
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)params);
        String number = jsonObject.getString("number");
        String status = jsonObject.getString("status");
        String info = jsonObject.getString("info");
        this.sapInterfaceImpl.legalPersonReceiveResult(number, status, info);
        return result;
    }

    private boolean fpCompanyInfoResultSap(String params) throws Exception {
        boolean result = false;
        Map map = (Map)com.alibaba.fastjson.JSONObject.toJavaObject((JSON)com.alibaba.fastjson.JSONObject.parseObject((String)params), Map.class);
        String resultStr = this.sapInterfaceImpl.companyInfoDataResult(map, "449694");
        com.alibaba.fastjson.JSONObject resultJson = com.alibaba.fastjson.JSONObject.parseObject((String)resultStr);
        String sTATUSCODE = resultJson.getString("sTATUSCODE");
        if ("S000".equals(sTATUSCODE)) {
            result = true;
        }
        return result;
    }

    private boolean fpCompanySettlementInsertSap(String params) throws Exception {
        boolean result = false;
        String url = this.apiUrl + "api/vanke-api/v1/companySettlementInsert";
        String json = HttpUtils.doJsonPost((String)url, (String)params);
        com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)json);
        String code = jsonObject.getJSONObject("result").getString("code");
        if ("200".equals(code)) {
            result = true;
        }
        return result;
    }

    private boolean fpCompanySettlementInsertNoConcerGX(String params) throws Exception {
        boolean result = false;
        String resultStr = this.gxInterfaceImpl.companySettlementInsertNoConcer((IMSI_REQUEST)JSON.parseObject((String)params, IMSI_REQUEST.class));
        com.alibaba.fastjson.JSONObject resultJson = com.alibaba.fastjson.JSONObject.parseObject((String)resultStr);
        String sTATUSCODE = resultJson.getString("sTATUSCODE");
        if ("S000".equals(sTATUSCODE)) {
            result = true;
        }
        return result;
    }

    private boolean fpCompanySettlementInsertGX(String params) throws Exception {
        boolean result = false;
        String resultStr = this.gxInterfaceImpl.companySettlementInsert((CompanySettlementInsertData)JSON.parseObject((String)params, CompanySettlementInsertData.class));
        com.alibaba.fastjson.JSONObject resultJson = com.alibaba.fastjson.JSONObject.parseObject((String)resultStr);
        String code = resultJson.getString("code");
        if ("200".equals(code)) {
            result = true;
        }
        return result;
    }
}

